#!/usr/local/bin/perl

# Thanks to Graham Barr <gbarr@ti.com> for contributing this test script!

use strict;
use Lingua::EN::Nums2Words;

my $DBG=0;
my $tests=9;
my $variations=3;
my $loops=2;

print "1..",$tests*$variations*$loops,"\n";

$/ = "";
my $i = 1;
my $DATA_start=tell DATA;
foreach my $case (qw(upper lower)) {
  Lingua::EN::Nums2Words::set_case($case);
  seek DATA, $DATA_start, 0;
  while(<DATA>) {
    my($num,$word,$ord,$short_ord,$dollar) = split(/\n/,$_);
    my $ok;

    $ok=(case($case,$word) eq &num2word($num));
    if (! $ok) {  print "not ";
      print "$word vs " .  &num2word($num) . "\n" if ($DBG);
    }
    printf "ok %d\n",$i++;

    $ok=(case($case,$ord) eq &num2word_ordinal($num));
    if (! $ok) {  print "not ";
      print "$ord vs " .  &num2word_ordinal($num) . "\n" if ($DBG);
    }
    printf "ok %d\n",$i++;

    if ($short_ord ne '__SKIP__') {
      $ok=(case($case,$short_ord) eq &num2word_short_ordinal($num));
      if (! $ok) {  print "not ";
        print "$ord vs " .  &num2word_short_ordinal($num) . "\n" if ($DBG);
      }
      printf "ok %d\n",$i++;
    }

    $ok=(case($case,$dollar) eq &num2usdollars($num));
    if (! $ok) {  print "not ";
      print "$dollar vs " .  &num2usdollars($num) . "\n" if ($DBG);
    }
    printf "ok %d\n",$i++;
  }
}

sub case($$) {
  my $word_case=shift @_;
  my $str=shift @_;
  if ($word_case eq 'upper') {
    return uc($str);
  } elsif ($word_case eq 'lower') {
    return lc($str);
  } else {
    retrn $str;
  }
}


__DATA__
-3793.793
NEGATIVE THREE THOUSAND, SEVEN HUNDRED NINETY-THREE AND SEVEN HUNDRED NINETY-THREE THOUSANDTHS
NEGATIVE THREE THOUSAND, SEVEN HUNDRED NINETY-THIRD AND SEVEN HUNDRED NINETY-THREE THOUSANDTHS
__SKIP__
NEGATIVE THREE THOUSAND, SEVEN HUNDRED NINETY-THREE DOLLARS AND SEVENTY-NINE CENTS

3875.5798
THREE THOUSAND, EIGHT HUNDRED SEVENTY-FIVE AND FIVE THOUSAND, SEVEN HUNDRED NINETY-EIGHT TEN-THOUSANDTHS
THREE THOUSAND, EIGHT HUNDRED SEVENTY-FIFTH AND FIVE THOUSAND, SEVEN HUNDRED NINETY-EIGHT TEN-THOUSANDTHS
__SKIP__
THREE THOUSAND, EIGHT HUNDRED SEVENTY-FIVE DOLLARS AND FIFTY-EIGHT CENTS

-318.2983
NEGATIVE THREE HUNDRED EIGHTEEN AND TWO THOUSAND, NINE HUNDRED EIGHTY-THREE TEN-THOUSANDTHS
NEGATIVE THREE HUNDRED EIGHTEENTH AND TWO THOUSAND, NINE HUNDRED EIGHTY-THREE TEN-THOUSANDTHS
__SKIP__
NEGATIVE THREE HUNDRED EIGHTEEN DOLLARS AND THIRTY CENTS

1466.8
ONE THOUSAND, FOUR HUNDRED SIXTY-SIX AND EIGHT TENTHS
ONE THOUSAND, FOUR HUNDRED SIXTY-SIXTH AND EIGHT TENTHS
__SKIP__
ONE THOUSAND, FOUR HUNDRED SIXTY-SIX DOLLARS AND EIGHTY CENTS

-554.05
NEGATIVE FIVE HUNDRED FIFTY-FOUR AND FIVE HUNDREDTHS
NEGATIVE FIVE HUNDRED FIFTY-FOURTH AND FIVE HUNDREDTHS
__SKIP__
NEGATIVE FIVE HUNDRED FIFTY-FOUR DOLLARS AND FIVE CENTS

1470.6421
ONE THOUSAND, FOUR HUNDRED SEVENTY AND SIX THOUSAND, FOUR HUNDRED TWENTY-ONE TEN-THOUSANDTHS
ONE THOUSAND, FOUR HUNDRED SEVENTIETH AND SIX THOUSAND, FOUR HUNDRED TWENTY-ONE TEN-THOUSANDTHS
__SKIP__
ONE THOUSAND, FOUR HUNDRED SEVENTY DOLLARS AND SIXTY-FOUR CENTS

.6421
ZERO AND SIX THOUSAND, FOUR HUNDRED TWENTY-ONE TEN-THOUSANDTHS
ZERO AND SIX THOUSAND, FOUR HUNDRED TWENTY-ONE TEN-THOUSANDTHS
__SKIP__
ZERO DOLLARS AND SIXTY-FOUR CENTS

476206098657263575912.476206098657263575912
FOUR HUNDRED SEVENTY-SIX QUINTILLION, TWO HUNDRED SIX QUADRILLION, NINETY-EIGHT TRILLION, SIX HUNDRED FIFTY-SEVEN BILLION, TWO HUNDRED SIXTY-THREE MILLION, FIVE HUNDRED SEVENTY-FIVE THOUSAND, NINE HUNDRED TWELVE AND FOUR HUNDRED SEVENTY-SIX QUINTILLION, TWO HUNDRED SIX QUADRILLION, NINETY-EIGHT TRILLION, SIX HUNDRED FIFTY-SEVEN BILLION, TWO HUNDRED SIXTY-THREE MILLION, FIVE HUNDRED SEVENTY-FIVE THOUSAND, NINE HUNDRED TWELVE DUODECILLIONTHS
FOUR HUNDRED SEVENTY-SIX QUINTILLION, TWO HUNDRED SIX QUADRILLION, NINETY-EIGHT TRILLION, SIX HUNDRED FIFTY-SEVEN BILLION, TWO HUNDRED SIXTY-THREE MILLION, FIVE HUNDRED SEVENTY-FIVE THOUSAND, NINE HUNDRED TWELFTH AND FOUR HUNDRED SEVENTY-SIX QUINTILLION, TWO HUNDRED SIX QUADRILLION, NINETY-EIGHT TRILLION, SIX HUNDRED FIFTY-SEVEN BILLION, TWO HUNDRED SIXTY-THREE MILLION, FIVE HUNDRED SEVENTY-FIVE THOUSAND, NINE HUNDRED TWELVE DUODECILLIONTHS
__SKIP__
FOUR HUNDRED SEVENTY-SIX QUINTILLION, TWO HUNDRED SIX QUADRILLION, NINETY-EIGHT TRILLION, SIX HUNDRED FIFTY-SEVEN BILLION, TWO HUNDRED SIXTY-THREE MILLION, FIVE HUNDRED SEVENTY-FIVE THOUSAND, NINE HUNDRED TWELVE DOLLARS AND FORTY-EIGHT CENTS

476206098657263575912.474206098657263575912
FOUR HUNDRED SEVENTY-SIX QUINTILLION, TWO HUNDRED SIX QUADRILLION, NINETY-EIGHT TRILLION, SIX HUNDRED FIFTY-SEVEN BILLION, TWO HUNDRED SIXTY-THREE MILLION, FIVE HUNDRED SEVENTY-FIVE THOUSAND, NINE HUNDRED TWELVE AND FOUR HUNDRED SEVENTY-FOUR QUINTILLION, TWO HUNDRED SIX QUADRILLION, NINETY-EIGHT TRILLION, SIX HUNDRED FIFTY-SEVEN BILLION, TWO HUNDRED SIXTY-THREE MILLION, FIVE HUNDRED SEVENTY-FIVE THOUSAND, NINE HUNDRED TWELVE DUODECILLIONTHS
FOUR HUNDRED SEVENTY-SIX QUINTILLION, TWO HUNDRED SIX QUADRILLION, NINETY-EIGHT TRILLION, SIX HUNDRED FIFTY-SEVEN BILLION, TWO HUNDRED SIXTY-THREE MILLION, FIVE HUNDRED SEVENTY-FIVE THOUSAND, NINE HUNDRED TWELFTH AND FOUR HUNDRED SEVENTY-FOUR QUINTILLION, TWO HUNDRED SIX QUADRILLION, NINETY-EIGHT TRILLION, SIX HUNDRED FIFTY-SEVEN BILLION, TWO HUNDRED SIXTY-THREE MILLION, FIVE HUNDRED SEVENTY-FIVE THOUSAND, NINE HUNDRED TWELVE DUODECILLIONTHS
__SKIP__
FOUR HUNDRED SEVENTY-SIX QUINTILLION, TWO HUNDRED SIX QUADRILLION, NINETY-EIGHT TRILLION, SIX HUNDRED FIFTY-SEVEN BILLION, TWO HUNDRED SIXTY-THREE MILLION, FIVE HUNDRED SEVENTY-FIVE THOUSAND, NINE HUNDRED TWELVE DOLLARS AND FORTY-SEVEN CENTS

113
ONE HUNDRED THIRTEEN
ONE HUNDRED THIRTEENTH
113th
ONE HUNDRED THIRTEEN DOLLARS AND ZERO CENTS

5112
FIVE THOUSAND, ONE HUNDRED TWELVE
FIVE THOUSAND, ONE HUNDRED TWELFTH
5112th
FIVE THOUSAND, ONE HUNDRED TWELVE DOLLARS AND ZERO CENTS

5122
FIVE THOUSAND, ONE HUNDRED TWENTY-TWO
FIVE THOUSAND, ONE HUNDRED TWENTY-SECOND
5122nd
FIVE THOUSAND, ONE HUNDRED TWENTY-TWO DOLLARS AND ZERO CENTS

6121
SIX THOUSAND, ONE HUNDRED TWENTY-ONE
SIX THOUSAND, ONE HUNDRED TWENTY-FIRST
6121st
SIX THOUSAND, ONE HUNDRED TWENTY-ONE DOLLARS AND ZERO CENTS
