/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core;

import java.util.EnumSet;
import org.apache.axiom.core.CoreCDATASection;
import org.apache.axiom.core.CoreCharacterDataNode;
import org.apache.axiom.core.CoreComment;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreDocumentFragment;
import org.apache.axiom.core.CoreDocumentTypeDeclaration;
import org.apache.axiom.core.CoreEntityReference;
import org.apache.axiom.core.CoreNSAwareAttribute;
import org.apache.axiom.core.CoreNSAwareElement;
import org.apache.axiom.core.CoreNSUnawareAttribute;
import org.apache.axiom.core.CoreNSUnawareElement;
import org.apache.axiom.core.CoreNamespaceDeclaration;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.CoreProcessingInstruction;

public enum NodeType {
    DOCUMENT(CoreDocument.class),
    DOCUMENT_TYPE_DECLARATION(CoreDocumentTypeDeclaration.class),
    NS_UNAWARE_ELEMENT(CoreNSUnawareElement.class),
    NS_AWARE_ELEMENT(CoreNSAwareElement.class),
    NS_UNAWARE_ATTRIBUTE(CoreNSUnawareAttribute.class),
    NS_AWARE_ATTRIBUTE(CoreNSAwareAttribute.class),
    NAMESPACE_DECLARATION(CoreNamespaceDeclaration.class),
    PROCESSING_INSTRUCTION(CoreProcessingInstruction.class),
    DOCUMENT_FRAGMENT(CoreDocumentFragment.class),
    CHARACTER_DATA(CoreCharacterDataNode.class),
    COMMENT(CoreComment.class),
    CDATA_SECTION(CoreCDATASection.class),
    ENTITY_REFERENCE(CoreEntityReference.class);

    private final Class<? extends CoreNode> iface;
    private EnumSet<NodeType> allowedChildTypes;

    private NodeType(Class<? extends CoreNode> iface) {
        this.iface = iface;
    }

    public Class<? extends CoreNode> getInterface() {
        return this.iface;
    }

    public boolean isChildTypeAllowed(NodeType childType) {
        if (this.allowedChildTypes == null) {
            throw new UnsupportedOperationException();
        }
        return this.allowedChildTypes.contains((Object)childType);
    }

    static {
        NodeType.COMMENT.allowedChildTypes = EnumSet.of(CHARACTER_DATA);
        NodeType.DOCUMENT.allowedChildTypes = EnumSet.of(CHARACTER_DATA, new NodeType[]{COMMENT, DOCUMENT_TYPE_DECLARATION, NS_AWARE_ELEMENT, NS_UNAWARE_ELEMENT, PROCESSING_INSTRUCTION});
        NodeType.DOCUMENT_FRAGMENT.allowedChildTypes = EnumSet.allOf(NodeType.class);
        EnumSet<NodeType> s = EnumSet.of(CHARACTER_DATA, ENTITY_REFERENCE);
        NodeType.NS_AWARE_ATTRIBUTE.allowedChildTypes = s;
        NodeType.NS_UNAWARE_ATTRIBUTE.allowedChildTypes = s;
        NodeType.NAMESPACE_DECLARATION.allowedChildTypes = s;
        s = EnumSet.of(CDATA_SECTION, new NodeType[]{CHARACTER_DATA, COMMENT, ENTITY_REFERENCE, NS_AWARE_ELEMENT, NS_UNAWARE_ELEMENT, PROCESSING_INSTRUCTION});
        NodeType.NS_AWARE_ELEMENT.allowedChildTypes = s;
        NodeType.NS_UNAWARE_ELEMENT.allowedChildTypes = s;
    }
}

