/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.resource.IPropertiesChangeListener;
import org.apache.wicket.resource.IPropertiesFactory;
import org.apache.wicket.resource.IPropertiesFactoryContext;
import org.apache.wicket.resource.IPropertiesLoader;
import org.apache.wicket.resource.IsoPropertiesFilePropertiesLoader;
import org.apache.wicket.resource.Properties;
import org.apache.wicket.resource.UtfPropertiesFilePropertiesLoader;
import org.apache.wicket.resource.XmlFilePropertiesLoader;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.listener.IChangeListener;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.value.ValueMap;
import org.apache.wicket.util.watch.IModifiable;
import org.apache.wicket.util.watch.IModificationWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFactory
implements IPropertiesFactory {
    private static final Logger log = LoggerFactory.getLogger(PropertiesFactory.class);
    private final List<IPropertiesChangeListener> afterReloadListeners = new ArrayList<IPropertiesChangeListener>();
    private final Map<String, Properties> propertiesCache = this.newPropertiesCache();
    private final IPropertiesFactoryContext context;
    private final List<IPropertiesLoader> propertiesLoader;

    public PropertiesFactory(IPropertiesFactoryContext context) {
        this.context = context;
        this.propertiesLoader = new ArrayList<IPropertiesLoader>();
        this.propertiesLoader.add(new IsoPropertiesFilePropertiesLoader("properties"));
        this.propertiesLoader.add(new UtfPropertiesFilePropertiesLoader("utf8.properties", "utf-8"));
        this.propertiesLoader.add(new XmlFilePropertiesLoader("properties.xml"));
    }

    public List<IPropertiesLoader> getPropertiesLoaders() {
        return this.propertiesLoader;
    }

    protected Map<String, Properties> newPropertiesCache() {
        return new ConcurrentHashMap<String, Properties>();
    }

    @Override
    public void addListener(IPropertiesChangeListener listener) {
        if (!this.afterReloadListeners.contains(listener)) {
            this.afterReloadListeners.add(listener);
        }
    }

    @Override
    public final void clearCache() {
        if (this.propertiesCache != null) {
            this.propertiesCache.clear();
        }
        this.context.getLocalizer().clearCache();
    }

    @Override
    public Properties load(Class<?> clazz, String path) {
        Properties properties = null;
        if (this.propertiesCache != null) {
            properties = this.propertiesCache.get(path);
        }
        if (properties == null) {
            Iterator<IPropertiesLoader> iter = this.propertiesLoader.iterator();
            while (properties == null && iter.hasNext()) {
                ValueMap props;
                IPropertiesLoader loader = iter.next();
                String fullPath = path + "." + loader.getFileExtension();
                IResourceStream resourceStream = this.context.getResourceStreamLocator().locate(clazz, fullPath);
                if (resourceStream == null) continue;
                IModificationWatcher watcher = this.context.getResourceWatcher(true);
                if (watcher != null) {
                    this.addToWatcher(path, resourceStream, watcher);
                }
                if ((props = this.loadFromLoader(loader, resourceStream)) == null) continue;
                properties = new Properties(path, props);
            }
            if (this.propertiesCache != null) {
                if (properties == null) {
                    this.propertiesCache.put(path, Properties.EMPTY_PROPERTIES);
                } else {
                    this.propertiesCache.put(path, properties);
                }
            }
        }
        if (properties == Properties.EMPTY_PROPERTIES) {
            properties = null;
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ValueMap loadFromLoader(IPropertiesLoader loader, IResourceStream resourceStream) {
        ValueMap valueMap;
        if (log.isDebugEnabled()) {
            log.debug("Loading properties files from '{}' with loader '{}'", (Object)resourceStream, (Object)loader);
        }
        BufferedInputStream in = null;
        try {
            java.util.Properties props;
            in = new BufferedInputStream(resourceStream.getInputStream());
            ValueMap data = loader.loadWicketProperties(in);
            if (data == null && (props = loader.loadJavaProperties(in)) != null) {
                data = new ValueMap();
                Enumeration<?> enumeration = props.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String property = (String)enumeration.nextElement();
                    data.put(property, (Object)props.getProperty(property));
                }
            }
            valueMap = data;
        }
        catch (IOException | ResourceStreamNotFoundException e) {
            try {
                log.warn("Unable to find resource " + resourceStream, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(resourceStream);
                throw throwable;
            }
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(resourceStream);
            return null;
        }
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(resourceStream);
        return valueMap;
    }

    protected void addToWatcher(final String path, final IResourceStream resourceStream, IModificationWatcher watcher) {
        watcher.add(resourceStream, new IChangeListener<IModifiable>(){

            @Override
            public void onChange(IModifiable modifiable) {
                log.info("A properties files has changed. Removing all entries from the cache. Resource: " + resourceStream);
                PropertiesFactory.this.clearCache();
                for (IPropertiesChangeListener listener : PropertiesFactory.this.afterReloadListeners) {
                    try {
                        listener.propertiesChanged(path);
                    }
                    catch (Exception ex) {
                        log.error("PropertiesReloadListener has thrown an exception: " + ex.getMessage());
                    }
                }
            }
        });
    }

    protected final Map<String, Properties> getCache() {
        return this.propertiesCache;
    }
}

