/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class HttpSessionCopy
implements HttpSession {
    private final long creationTime;
    private final ConcurrentHashMap<String, Object> attributes;
    private final String sessionId;
    private final ServletContext servletContext;
    private int maxInactiveInterval;

    public HttpSessionCopy(HttpSession originalSession) {
        this.sessionId = originalSession.getId();
        this.servletContext = originalSession.getServletContext();
        this.creationTime = originalSession.getCreationTime();
        this.attributes = new ConcurrentHashMap();
        Enumeration attributeNames = originalSession.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            Object attributeValue = originalSession.getAttribute(attributeName);
            this.attributes.put(attributeName, attributeValue);
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.sessionId;
    }

    public long getLastAccessedTime() {
        return 0L;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object getValue(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.attributes.keys();
    }

    public String[] getValueNames() {
        return Collections.list(this.attributes.keys()).toArray(new String[0]);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void putValue(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void removeValue(String name) {
        this.attributes.remove(name);
    }

    public void invalidate() {
        this.attributes.clear();
    }

    public boolean isNew() {
        return false;
    }
}

