/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.response;

import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class LazyStringResponse
extends Response {
    private static final int DEFAULT_INITIAL_CAPACITY = 128;
    private final int initialCapacity;
    private AppendingStringBuffer out;

    public LazyStringResponse() {
        this(128);
    }

    public LazyStringResponse(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public void write(CharSequence string) {
        if (this.out == null) {
            this.out = new AppendingStringBuffer(this.initialCapacity);
        }
        this.out.append((Object)string);
    }

    public void reset() {
        if (this.out != null) {
            this.out.clear();
        }
    }

    public String toString() {
        return this.getBuffer().toString();
    }

    public CharSequence getBuffer() {
        return this.out != null ? this.out : "";
    }

    public void write(byte[] array) {
        throw new UnsupportedOperationException();
    }

    public void write(byte[] array, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    public String encodeURL(CharSequence url) {
        return url != null ? url.toString() : null;
    }

    public Object getContainerResponse() {
        return null;
    }
}

