/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.clustering.peerpressure;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.configuration2.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.util.StaticMapReduce;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class ClusterCountMapReduce
extends StaticMapReduce<MapReduce.NullObject, Serializable, MapReduce.NullObject, Integer, Integer> {
    public static final String CLUSTER_COUNT_MEMORY_KEY = "gremlin.clusterCountMapReduce.memoryKey";
    public static final String DEFAULT_MEMORY_KEY = "clusterCount";
    private String memoryKey = "clusterCount";

    private ClusterCountMapReduce() {
    }

    private ClusterCountMapReduce(String memoryKey) {
        this.memoryKey = memoryKey;
    }

    @Override
    public void storeState(Configuration configuration) {
        super.storeState(configuration);
        configuration.setProperty(CLUSTER_COUNT_MEMORY_KEY, (Object)this.memoryKey);
    }

    @Override
    public void loadState(Graph graph, Configuration configuration) {
        this.memoryKey = configuration.getString(CLUSTER_COUNT_MEMORY_KEY, DEFAULT_MEMORY_KEY);
    }

    @Override
    public boolean doStage(MapReduce.Stage stage) {
        return !stage.equals((Object)MapReduce.Stage.COMBINE);
    }

    @Override
    public void map(Vertex vertex, MapReduce.MapEmitter<MapReduce.NullObject, Serializable> emitter) {
        Property cluster = vertex.property("gremlin.peerPressureVertexProgram.cluster");
        if (cluster.isPresent()) {
            emitter.emit(MapReduce.NullObject.instance(), (Serializable)cluster.value());
        }
    }

    @Override
    public void reduce(MapReduce.NullObject key, Iterator<Serializable> values, MapReduce.ReduceEmitter<MapReduce.NullObject, Integer> emitter) {
        HashSet set = new HashSet();
        values.forEachRemaining(set::add);
        emitter.emit(MapReduce.NullObject.instance(), set.size());
    }

    @Override
    public Integer generateFinalResult(Iterator<KeyValue<MapReduce.NullObject, Integer>> keyValues) {
        return keyValues.next().getValue();
    }

    @Override
    public String getMemoryKey() {
        return this.memoryKey;
    }

    @Override
    public String toString() {
        return StringFactory.mapReduceString(this, this.memoryKey);
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder {
        private String memoryKey = "clusterCount";

        private Builder() {
        }

        public Builder memoryKey(String memoryKey) {
            this.memoryKey = memoryKey;
            return this;
        }

        public ClusterCountMapReduce create() {
            return new ClusterCountMapReduce(this.memoryKey);
        }
    }
}

