/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.pprof;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.profiling.pprof.storage.PprofProfilingDataRecord;
import org.apache.skywalking.oap.server.core.query.PprofTaskLog;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.PprofStackTree;
import org.apache.skywalking.oap.server.core.query.type.PprofTask;
import org.apache.skywalking.oap.server.core.storage.profiling.pprof.IPprofDataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.pprof.IPprofTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.pprof.IPprofTaskQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.pprof.parser.PprofMergeBuilder;
import org.apache.skywalking.oap.server.library.pprof.type.FrameTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PprofQueryService
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PprofQueryService.class);
    private static final Gson GSON = new Gson();
    private final ModuleManager moduleManager;
    private IPprofTaskQueryDAO taskQueryDAO;
    private IPprofDataQueryDAO dataQueryDAO;
    private IPprofTaskLogQueryDAO logQueryDAO;

    private IPprofTaskQueryDAO getTaskQueryDAO() {
        if (this.taskQueryDAO == null) {
            this.taskQueryDAO = (IPprofTaskQueryDAO)this.moduleManager.find("storage").provider().getService(IPprofTaskQueryDAO.class);
        }
        return this.taskQueryDAO;
    }

    private IPprofDataQueryDAO getPprofDataQueryDAO() {
        if (this.dataQueryDAO == null) {
            this.dataQueryDAO = (IPprofDataQueryDAO)this.moduleManager.find("storage").provider().getService(IPprofDataQueryDAO.class);
        }
        return this.dataQueryDAO;
    }

    private IPprofTaskLogQueryDAO getTaskLogQueryDAO() {
        if (this.logQueryDAO == null) {
            this.logQueryDAO = (IPprofTaskLogQueryDAO)this.moduleManager.find("storage").provider().getService(IPprofTaskLogQueryDAO.class);
        }
        return this.logQueryDAO;
    }

    public List<PprofTask> queryTask(String serviceId, Duration duration, Integer limit) throws IOException {
        Long startTimeBucket = null;
        Long endTimeBucket = null;
        if (Objects.nonNull(duration)) {
            startTimeBucket = duration.getStartTimeBucketInSec();
            endTimeBucket = duration.getEndTimeBucketInSec();
        }
        List<PprofTask> tasks = this.getTaskQueryDAO().getTaskList(serviceId, startTimeBucket, endTimeBucket, limit);
        return tasks;
    }

    public PprofStackTree queryPprofData(String taskId, List<String> instanceIds) throws IOException {
        List<PprofProfilingDataRecord> pprofDataList = this.getPprofDataQueryDAO().getByTaskIdAndInstances(taskId, instanceIds);
        List trees = pprofDataList.stream().map(data -> (FrameTree)GSON.fromJson(new String(data.getDataBinary()), FrameTree.class)).collect(Collectors.toList());
        FrameTree resultTree = new PprofMergeBuilder().merge(trees).build();
        return new PprofStackTree(resultTree);
    }

    public List<PprofTaskLog> queryPprofTaskLogs(String taskId) throws IOException {
        List<PprofTaskLog> taskLogList = this.getTaskLogQueryDAO().getTaskLogList();
        return this.findMatchedLogs(taskId, taskLogList);
    }

    private List<PprofTaskLog> findMatchedLogs(String taskID, List<PprofTaskLog> allLogs) {
        return allLogs.stream().filter(l -> Objects.equals(l.getId(), taskID)).map(this::extendTaskLog).collect(Collectors.toList());
    }

    private PprofTaskLog extendTaskLog(PprofTaskLog log) {
        IDManager.ServiceInstanceID.InstanceIDDefinition instanceIDDefinition = IDManager.ServiceInstanceID.analysisId(log.getInstanceId());
        log.setInstanceName(instanceIDDefinition.getName());
        return log;
    }

    @Generated
    public PprofQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }
}

