/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.config.database;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.version.MetaDataVersion;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.mode.metadata.persist.service.version.MetaDataVersionPersistService;
import org.apache.shardingsphere.mode.node.path.metadata.DataSourceMetaDataNodePath;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class DataSourceUnitPersistService {
    private final PersistRepository repository;
    private final MetaDataVersionPersistService metaDataVersionPersistService;

    public DataSourceUnitPersistService(PersistRepository repository) {
        this.repository = repository;
        this.metaDataVersionPersistService = new MetaDataVersionPersistService(repository);
    }

    public Map<String, DataSourcePoolProperties> load(String databaseName) {
        List childrenKeys = this.repository.getChildrenKeys(DataSourceMetaDataNodePath.getStorageUnitsPath((String)databaseName));
        return childrenKeys.stream().collect(Collectors.toMap(each -> each, each -> this.load(databaseName, (String)each), (a, b) -> b, () -> new LinkedHashMap(childrenKeys.size(), 1.0f)));
    }

    public DataSourcePoolProperties load(String databaseName, String dataSourceName) {
        String dataSourceValue = this.repository.query(DataSourceMetaDataNodePath.getStorageUnitVersionPath((String)databaseName, (String)dataSourceName, (String)this.getDataSourceActiveVersion(databaseName, dataSourceName)));
        return new YamlDataSourceConfigurationSwapper().swapToDataSourcePoolProperties((Map)YamlEngine.unmarshal((String)dataSourceValue, Map.class));
    }

    public Collection<MetaDataVersion> persist(String databaseName, Map<String, DataSourcePoolProperties> dataSourcePropsMap) {
        LinkedList<MetaDataVersion> result = new LinkedList<MetaDataVersion>();
        for (Map.Entry<String, DataSourcePoolProperties> entry : dataSourcePropsMap.entrySet()) {
            String activeVersion = this.getDataSourceActiveVersion(databaseName, entry.getKey());
            List<String> versions = this.metaDataVersionPersistService.getVersions(DataSourceMetaDataNodePath.getStorageUnitVersionsPath((String)databaseName, (String)entry.getKey()));
            String nextActiveVersion = versions.isEmpty() ? "0" : String.valueOf(Integer.parseInt(versions.get(0)) + 1);
            this.repository.persist(DataSourceMetaDataNodePath.getStorageUnitVersionPath((String)databaseName, (String)entry.getKey(), (String)nextActiveVersion), YamlEngine.marshal((Object)new YamlDataSourceConfigurationSwapper().swapToMap(entry.getValue())));
            if (Strings.isNullOrEmpty((String)activeVersion)) {
                this.repository.persist(DataSourceMetaDataNodePath.getStorageUnitActiveVersionPath((String)databaseName, (String)entry.getKey()), "0");
            }
            result.add(new MetaDataVersion(DataSourceMetaDataNodePath.getStorageUnitPath((String)databaseName, (String)entry.getKey()), activeVersion, nextActiveVersion));
        }
        return result;
    }

    private String getDataSourceActiveVersion(String databaseName, String dataSourceName) {
        return this.repository.query(DataSourceMetaDataNodePath.getStorageUnitActiveVersionPath((String)databaseName, (String)dataSourceName));
    }

    public void delete(String databaseName, String dataSourceName) {
        this.repository.delete(DataSourceMetaDataNodePath.getStorageUnitPath((String)databaseName, (String)dataSourceName));
    }
}

