/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.core.util;

import lombok.Generated;
import org.apache.shardingsphere.agent.plugin.core.enums.SQLStatementType;
import org.apache.shardingsphere.distsql.statement.DistSQLStatement;
import org.apache.shardingsphere.distsql.statement.ral.RALStatement;
import org.apache.shardingsphere.distsql.statement.rdl.RDLStatement;
import org.apache.shardingsphere.distsql.statement.rql.RQLStatement;
import org.apache.shardingsphere.distsql.statement.rul.RULStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dcl.DCLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.TCLStatement;

public final class SQLStatementUtils {
    public static SQLStatementType getType(SQLStatement sqlStatement) {
        if (null == sqlStatement) {
            return SQLStatementType.OTHER;
        }
        if (sqlStatement instanceof DMLStatement) {
            return SQLStatementUtils.getDMLType(sqlStatement);
        }
        if (sqlStatement instanceof DDLStatement) {
            return SQLStatementType.DDL;
        }
        if (sqlStatement instanceof DCLStatement) {
            return SQLStatementType.DCL;
        }
        if (sqlStatement instanceof DALStatement) {
            return SQLStatementType.DAL;
        }
        if (sqlStatement instanceof TCLStatement) {
            return SQLStatementType.TCL;
        }
        if (sqlStatement instanceof DistSQLStatement) {
            return SQLStatementUtils.getDistSQLType(sqlStatement);
        }
        return SQLStatementType.OTHER;
    }

    private static SQLStatementType getDMLType(SQLStatement sqlStatement) {
        if (sqlStatement instanceof SelectStatement) {
            return SQLStatementType.SELECT;
        }
        if (sqlStatement instanceof InsertStatement) {
            return SQLStatementType.INSERT;
        }
        if (sqlStatement instanceof UpdateStatement) {
            return SQLStatementType.UPDATE;
        }
        if (sqlStatement instanceof DeleteStatement) {
            return SQLStatementType.DELETE;
        }
        return SQLStatementType.DML;
    }

    private static SQLStatementType getDistSQLType(SQLStatement sqlStatement) {
        if (sqlStatement instanceof RQLStatement) {
            return SQLStatementType.RQL;
        }
        if (sqlStatement instanceof RDLStatement) {
            return SQLStatementType.RDL;
        }
        if (sqlStatement instanceof RALStatement) {
            return SQLStatementType.RAL;
        }
        if (sqlStatement instanceof RULStatement) {
            return SQLStatementType.RUL;
        }
        return SQLStatementType.OTHER;
    }

    @Generated
    private SQLStatementUtils() {
    }
}

