/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.core;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import org.opengauss.PGProperty;
import org.opengauss.core.PGStream;
import org.opengauss.core.QueryExecutor;
import org.opengauss.core.v3.ConnectionFactoryImpl;
import org.opengauss.log.Log;
import org.opengauss.log.Logger;
import org.opengauss.util.GT;
import org.opengauss.util.HostSpec;
import org.opengauss.util.PSQLException;
import org.opengauss.util.PSQLState;

public abstract class ConnectionFactory {
    private static Log LOGGER = Logger.getLogger(ConnectionFactory.class.getName());

    public static QueryExecutor openConnection(HostSpec[] hostSpecs, String user, String database, Properties info) throws SQLException {
        ConnectionFactoryImpl connectionFactory;
        QueryExecutor queryExecutor;
        String protoName = PGProperty.PROTOCOL_VERSION.get(info);
        if ((protoName == null || protoName.isEmpty() || "3".equals(protoName)) && (queryExecutor = ((ConnectionFactory)(connectionFactory = new ConnectionFactoryImpl())).openConnectionImpl(hostSpecs, user, database, info)) != null) {
            return queryExecutor;
        }
        throw new PSQLException(GT.tr("A connection could not be made using the requested protocol {0}.", protoName), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    public abstract QueryExecutor openConnectionImpl(HostSpec[] var1, String var2, String var3, Properties var4) throws SQLException;

    protected void closeStream(PGStream newStream) {
        if (newStream != null) {
            try {
                newStream.close();
            }
            catch (IOException e) {
                LOGGER.trace("Catch IOException on close:", e);
            }
        }
    }
}

