/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.string;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.MySQLBinlogColumnDef;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.MySQLBinlogProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.string.MySQLJsonValueDecoder;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;

public final class MySQLJsonBinlogProtocolValue
implements MySQLBinlogProtocolValue {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable read(MySQLBinlogColumnDef columnDef, MySQLPacketPayload payload) {
        ByteBuf newlyByteBuf = payload.getByteBuf().readBytes(this.readLengthFromMeta(columnDef.getColumnMeta(), payload));
        try {
            Serializable serializable = MySQLJsonValueDecoder.decode(newlyByteBuf);
            return serializable;
        }
        finally {
            newlyByteBuf.release();
        }
    }

    private int readLengthFromMeta(int columnMeta, MySQLPacketPayload payload) {
        switch (columnMeta) {
            case 1: {
                return payload.getByteBuf().readUnsignedByte();
            }
            case 2: {
                return payload.getByteBuf().readUnsignedShortLE();
            }
            case 3: {
                return payload.getByteBuf().readUnsignedMediumLE();
            }
            case 4: {
                return payload.readInt4();
            }
        }
        throw new UnsupportedSQLOperationException(String.format("MySQL JSON type meta in binlog should be range 1 to 4, but actual value is: %s", columnMeta));
    }
}

