/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.view;

import java.util.function.Supplier;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.Clock;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.RandomSupplier;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.Aggregation;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.InstrumentType;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.PointData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.DoubleLastValueAggregator;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.LongLastValueAggregator;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;

public final class LastValueAggregation
implements Aggregation,
AggregatorFactory {
    private static final Aggregation INSTANCE = new LastValueAggregation();

    public static Aggregation getInstance() {
        return INSTANCE;
    }

    private LastValueAggregation() {
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter, MemoryMode memoryMode) {
        switch (instrumentDescriptor.getValueType()) {
            case LONG: {
                Supplier<ExemplarReservoir<LongExemplarData>> reservoirFactory = () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.longFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault()));
                return new LongLastValueAggregator(reservoirFactory, memoryMode);
            }
            case DOUBLE: {
                Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirFactory = () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.doubleFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault()));
                return new DoubleLastValueAggregator(reservoirFactory, memoryMode);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        InstrumentType instrumentType = instrumentDescriptor.getType();
        return instrumentType == InstrumentType.OBSERVABLE_GAUGE || instrumentType == InstrumentType.GAUGE;
    }

    public String toString() {
        return "LastValueAggregation";
    }
}

