/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorClusterModeRequired;
import org.apache.shardingsphere.distsql.statement.ral.updatable.UnlabelComputeNodeStatement;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.mode.manager.ContextManager;

@DistSQLExecutorClusterModeRequired
public final class UnlabelComputeNodeExecutor
implements DistSQLUpdateExecutor<UnlabelComputeNodeStatement> {
    public void executeUpdate(UnlabelComputeNodeStatement sqlStatement, ContextManager contextManager) {
        String instanceId = sqlStatement.getInstanceId();
        Optional computeNodeInstance = contextManager.getComputeNodeInstanceContext().getClusterInstanceRegistry().find(instanceId);
        if (computeNodeInstance.isPresent()) {
            LinkedHashSet labels = new LinkedHashSet(((ComputeNodeInstance)computeNodeInstance.get()).getLabels());
            if (sqlStatement.getLabels().isEmpty()) {
                contextManager.getPersistServiceFacade().getComputeNodePersistService().persistLabels(instanceId, Collections.emptyList());
            } else {
                labels.removeAll(sqlStatement.getLabels());
                contextManager.getPersistServiceFacade().getComputeNodePersistService().persistLabels(instanceId, new ArrayList(labels));
            }
        }
    }

    public Class<UnlabelComputeNodeStatement> getType() {
        return UnlabelComputeNodeStatement.class;
    }
}

