/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.metadata.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.metadata.database.schema.manager.GenericSchemaManager;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.mode.metadata.persist.service.metadata.table.TableMetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.metadata.table.ViewMetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.version.MetaDataVersionPersistService;
import org.apache.shardingsphere.mode.node.path.metadata.DatabaseMetaDataNodePath;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class SchemaMetaDataPersistService {
    private final PersistRepository repository;
    private final TableMetaDataPersistService tableMetaDataPersistService;
    private final ViewMetaDataPersistService viewMetaDataPersistService;

    public SchemaMetaDataPersistService(PersistRepository repository, MetaDataVersionPersistService metaDataVersionPersistService) {
        this.repository = repository;
        this.tableMetaDataPersistService = new TableMetaDataPersistService(repository, metaDataVersionPersistService);
        this.viewMetaDataPersistService = new ViewMetaDataPersistService(repository, metaDataVersionPersistService);
    }

    public void add(String databaseName, String schemaName) {
        this.repository.persist(DatabaseMetaDataNodePath.getTableRootPath((String)databaseName, (String)schemaName), "");
    }

    public void drop(String databaseName, String schemaName) {
        this.repository.delete(DatabaseMetaDataNodePath.getSchemaPath((String)databaseName, (String)schemaName));
    }

    public void alterByRefresh(String databaseName, ShardingSphereSchema schema) {
        String schemaName = schema.getName().toLowerCase();
        if (schema.isEmpty()) {
            this.add(databaseName, schemaName);
        }
        ShardingSphereSchema currentSchema = new ShardingSphereSchema(schemaName, this.tableMetaDataPersistService.load(databaseName, schemaName), Collections.emptyList());
        this.tableMetaDataPersistService.persist(databaseName, schemaName, GenericSchemaManager.getToBeAddedTables((ShardingSphereSchema)schema, (ShardingSphereSchema)currentSchema));
        GenericSchemaManager.getToBeDroppedTables((ShardingSphereSchema)schema, (ShardingSphereSchema)currentSchema).forEach(each -> this.tableMetaDataPersistService.drop(databaseName, schemaName, each.getName()));
    }

    public void alterByRuleAltered(String databaseName, ShardingSphereSchema schema) {
        String schemaName = schema.getName().toLowerCase();
        if (schema.isEmpty()) {
            this.add(databaseName, schemaName);
        }
        this.tableMetaDataPersistService.persist(databaseName, schemaName, schema.getAllTables());
    }

    public void alterByRuleDropped(String databaseName, ShardingSphereSchema schema) {
        this.tableMetaDataPersistService.persist(databaseName, schema.getName(), schema.getAllTables());
    }

    public Collection<ShardingSphereSchema> load(String databaseName) {
        return this.repository.getChildrenKeys(DatabaseMetaDataNodePath.getSchemaRootPath((String)databaseName)).stream().map(each -> new ShardingSphereSchema(each, this.tableMetaDataPersistService.load(databaseName, (String)each), this.viewMetaDataPersistService.load(databaseName, (String)each))).collect(Collectors.toList());
    }
}

