/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.DerivedProjection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.NullsOrderType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.RouteContextAware;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.rewrite.token.generator.IgnoreForSingleRoute;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.ProjectionsToken;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class ShardingProjectionsTokenGenerator
implements OptionalSQLTokenGenerator<SelectStatementContext>,
IgnoreForSingleRoute,
RouteContextAware {
    private RouteContext routeContext;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && this.containsDerivedProjections((SelectStatementContext)sqlStatementContext);
    }

    private boolean containsDerivedProjections(SelectStatementContext selectStatementContext) {
        for (Projection each : selectStatementContext.getProjectionsContext().getProjections()) {
            if ((!(each instanceof AggregationProjection) || ((AggregationProjection)each).getDerivedAggregationProjections().isEmpty()) && !(each instanceof DerivedProjection)) continue;
            return true;
        }
        return false;
    }

    public ProjectionsToken generateSQLToken(SelectStatementContext selectStatementContext) {
        Map<RouteUnit, Collection<String>> derivedProjectionTexts = this.getDerivedProjectionTexts(selectStatementContext);
        return new ProjectionsToken(selectStatementContext.getProjectionsContext().getStopIndex() + 1 + " ".length(), derivedProjectionTexts);
    }

    private Map<RouteUnit, Collection<String>> getDerivedProjectionTexts(SelectStatementContext selectStatementContext) {
        HashMap<RouteUnit, Collection<String>> result = new HashMap<RouteUnit, Collection<String>>(this.routeContext.getRouteUnits().size(), 1.0f);
        for (RouteUnit each : this.routeContext.getRouteUnits()) {
            result.put(each, this.getDerivedProjectionTexts(selectStatementContext, each));
        }
        return result;
    }

    private Collection<String> getDerivedProjectionTexts(SelectStatementContext selectStatementContext, RouteUnit routeUnit) {
        LinkedList<String> result = new LinkedList<String>();
        for (Projection each : selectStatementContext.getProjectionsContext().getProjections()) {
            if (each instanceof AggregationProjection) {
                result.addAll(((AggregationProjection)each).getDerivedAggregationProjections().stream().map(this::getDerivedProjectionText).collect(Collectors.toList()));
                continue;
            }
            if (each instanceof DerivedProjection && ((DerivedProjection)each).getDerivedProjectionSegment() instanceof ColumnOrderByItemSegment) {
                TableExtractor tableExtractor = new TableExtractor();
                tableExtractor.extractTablesFromSelect(selectStatementContext.getSqlStatement());
                result.add(this.getDerivedProjectionText((DerivedProjection)each, tableExtractor, routeUnit, selectStatementContext.getDatabaseType()));
                continue;
            }
            if (!(each instanceof DerivedProjection)) continue;
            result.add(this.getDerivedProjectionText(each));
        }
        return result;
    }

    private String getDerivedProjectionText(Projection projection) {
        Preconditions.checkState((boolean)projection.getAlias().isPresent());
        String projectionExpression = projection instanceof AggregationDistinctProjection ? ((AggregationDistinctProjection)projection).getDistinctInnerExpression() : projection.getExpression();
        return projectionExpression + " AS " + ((IdentifierValue)projection.getAlias().get()).getValue() + " ";
    }

    private String getDerivedProjectionText(DerivedProjection projection, TableExtractor tableExtractor, RouteUnit routeUnit, DatabaseType databaseType) {
        Preconditions.checkState((boolean)projection.getAlias().isPresent());
        Preconditions.checkState((boolean)(projection.getDerivedProjectionSegment() instanceof ColumnOrderByItemSegment));
        ColumnOrderByItemSegment columnOrderByItemSegment = (ColumnOrderByItemSegment)projection.getDerivedProjectionSegment();
        ColumnOrderByItemSegment newColumnOrderByItem = this.generateNewColumnOrderByItem(columnOrderByItemSegment, routeUnit, tableExtractor, databaseType);
        return newColumnOrderByItem.getText() + " AS " + ((IdentifierValue)projection.getAlias().get()).getValue() + " ";
    }

    private ColumnOrderByItemSegment generateNewColumnOrderByItem(ColumnOrderByItemSegment old, RouteUnit routeUnit, TableExtractor tableExtractor, DatabaseType databaseType) {
        Optional ownerSegment = old.getColumn().getOwner();
        if (!ownerSegment.isPresent() || !tableExtractor.needRewrite((OwnerSegment)ownerSegment.get())) {
            return old;
        }
        String actualTableName = this.getActualTableName(routeUnit, ((OwnerSegment)ownerSegment.get()).getIdentifier().getValue());
        OwnerSegment newOwner = new OwnerSegment(0, 0, new IdentifierValue(((OwnerSegment)ownerSegment.get()).getIdentifier().getQuoteCharacter().wrap(actualTableName)));
        ColumnSegment newColumnSegment = new ColumnSegment(0, 0, old.getColumn().getIdentifier());
        newColumnSegment.setOwner(newOwner);
        NullsOrderType nullsOrderType = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getDefaultNullsOrderType().getResolvedOrderType(old.getOrderDirection().name());
        return new ColumnOrderByItemSegment(newColumnSegment, old.getOrderDirection(), nullsOrderType);
    }

    private String getActualTableName(RouteUnit routeUnit, String logicalTableName) {
        for (RouteMapper each : routeUnit.getTableMappers()) {
            if (!each.getLogicName().equalsIgnoreCase(logicalTableName)) continue;
            return each.getActualName();
        }
        throw new IllegalStateException(String.format("Cannot find actual table name with logic table name '%s'", logicalTableName));
    }

    @Generated
    public void setRouteContext(RouteContext routeContext) {
        this.routeContext = routeContext;
    }
}

