/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.ConstraintAvailable;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.ConstraintToken;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class ShardingConstraintTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext> {
    private final ShardingRule rule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof ConstraintAvailable && !((ConstraintAvailable)sqlStatementContext).getConstraints().isEmpty();
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        if (sqlStatementContext instanceof ConstraintAvailable) {
            for (ConstraintSegment each : ((ConstraintAvailable)sqlStatementContext).getConstraints()) {
                IdentifierValue constraintIdentifier = each.getIdentifier();
                if (null == constraintIdentifier) continue;
                result.add(new ConstraintToken(each.getStartIndex(), each.getStopIndex(), constraintIdentifier, sqlStatementContext, this.rule));
            }
        }
        return result;
    }

    @Generated
    public ShardingConstraintTokenGenerator(ShardingRule rule) {
        this.rule = rule;
    }
}

