/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.checker.sql.common;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.table.NoSuchTableException;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.table.TableExistsException;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sharding.exception.syntax.DMLWithMultipleShardingTablesException;
import org.apache.shardingsphere.sharding.exception.syntax.UnsupportedShardingOperationException;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;

public final class ShardingSupportedCommonChecker {
    public static void checkShardingTable(ShardingRule shardingRule, String operation, Collection<SimpleTableSegment> tables) {
        for (SimpleTableSegment each : tables) {
            String tableName = each.getTableName().getIdentifier().getValue();
            ShardingSpherePreconditions.checkState((!shardingRule.isShardingTable(tableName) ? 1 : 0) != 0, () -> new UnsupportedShardingOperationException(operation, tableName));
        }
    }

    public static void checkTableExist(ShardingSphereSchema schema, Collection<SimpleTableSegment> tables) {
        for (SimpleTableSegment each : tables) {
            String tableName = each.getTableName().getIdentifier().getValue();
            ShardingSpherePreconditions.checkState((boolean)schema.containsTable(tableName), () -> new NoSuchTableException(tableName));
        }
    }

    public static void checkTableNotExist(ShardingSphereSchema schema, Collection<SimpleTableSegment> tables) {
        for (SimpleTableSegment each : tables) {
            String tableName = each.getTableName().getIdentifier().getValue();
            ShardingSpherePreconditions.checkState((!schema.containsTable(tableName) ? 1 : 0) != 0, () -> new TableExistsException(tableName));
        }
    }

    public static void checkMultipleTable(ShardingRule shardingRule, SQLStatementContext sqlStatementContext) {
        Collection tableNames = ((TableAvailable)sqlStatementContext).getTablesContext().getTableNames();
        boolean isAllShardingTables = shardingRule.isAllShardingTables(tableNames) && (1 == tableNames.size() || shardingRule.isAllConfigBindingTables(tableNames));
        boolean isAllSingleTables = !shardingRule.containsShardingTable(tableNames);
        ShardingSpherePreconditions.checkState((isAllShardingTables || isAllSingleTables ? 1 : 0) != 0, () -> new DMLWithMultipleShardingTablesException(tableNames));
    }

    @Generated
    private ShardingSupportedCommonChecker() {
    }
}

