/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.pojo;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptAssignmentToken;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;

public final class EncryptFunctionAssignmentToken
extends EncryptAssignmentToken {
    private final StringBuilder builder = new StringBuilder();
    private final Collection<FunctionAssignment> assignments = new LinkedList<FunctionAssignment>();

    public EncryptFunctionAssignmentToken(int startIndex, int stopIndex, QuoteCharacter quoteCharacter) {
        super(startIndex, stopIndex, quoteCharacter);
    }

    public void addAssignment(String columnName, Object value) {
        FunctionAssignment functionAssignment = new FunctionAssignment(columnName, value, this.getQuoteCharacter());
        this.assignments.add(functionAssignment);
        this.builder.append(functionAssignment).append(", ");
    }

    public boolean isAssignmentsEmpty() {
        return this.assignments.isEmpty();
    }

    public String toString() {
        return this.builder.substring(0, this.builder.length() - 2);
    }

    private static final class FunctionAssignment {
        private final String columnName;
        private final Object value;
        private final QuoteCharacter quoteCharacter;

        public String toString() {
            return this.quoteCharacter.wrap(this.columnName) + " = " + this.value;
        }

        @Generated
        public FunctionAssignment(String columnName, Object value, QuoteCharacter quoteCharacter) {
            this.columnName = columnName;
            this.value = value;
            this.quoteCharacter = quoteCharacter;
        }
    }
}

