/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.adapter.executor;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.driver.jdbc.adapter.executor.ForceExecuteCallback;

public final class ForceExecuteTemplate<T> {
    public void execute(Collection<T> targets, ForceExecuteCallback<T> callback) throws SQLException {
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        for (T each : targets) {
            try {
                callback.execute(each);
            }
            catch (SQLException ex) {
                exceptions.add(ex);
            }
        }
        this.throwSQLExceptionIfNecessary(exceptions);
    }

    private void throwSQLExceptionIfNecessary(Collection<SQLException> exceptions) throws SQLException {
        if (exceptions.isEmpty()) {
            return;
        }
        SQLException ex = new SQLException("");
        exceptions.forEach(ex::setNextException);
        throw ex;
    }
}

