/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.adapter;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.unsupported.AbstractUnsupportedOperationPreparedStatement;
import org.apache.shardingsphere.infra.exception.generic.UnknownSQLException;

public abstract class AbstractPreparedStatementAdapter
extends AbstractUnsupportedOperationPreparedStatement {
    private final List<PreparedStatementInvocationReplayer> setParameterMethodInvocations = new LinkedList<PreparedStatementInvocationReplayer>();
    private final List<Object> parameters = new ArrayList<Object>();

    @Override
    public final void setNull(int parameterIndex, int sqlType) {
        this.setParameter(parameterIndex, null);
    }

    @Override
    public final void setNull(int parameterIndex, int sqlType, String typeName) {
        this.setParameter(parameterIndex, null);
    }

    @Override
    public final void setBoolean(int parameterIndex, boolean x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setByte(int parameterIndex, byte x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setShort(int parameterIndex, short x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setInt(int parameterIndex, int x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setLong(int parameterIndex, long x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setFloat(int parameterIndex, float x) {
        this.setParameter(parameterIndex, Float.valueOf(x));
    }

    @Override
    public final void setDouble(int parameterIndex, double x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setString(int parameterIndex, String x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setBigDecimal(int parameterIndex, BigDecimal x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setDate(int parameterIndex, Date x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setDate(int parameterIndex, Date x, Calendar cal) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setTime(int parameterIndex, Time x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setTime(int parameterIndex, Time x, Calendar cal) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setTimestamp(int parameterIndex, Timestamp x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setBytes(int parameterIndex, byte[] x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setBlob(int parameterIndex, Blob x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setBlob(int parameterIndex, InputStream x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setBlob(int parameterIndex, InputStream x, long length) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setClob(int parameterIndex, Clob x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setClob(int parameterIndex, Reader x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setClob(int parameterIndex, Reader x, long length) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x, int length) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x, long length) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setUnicodeStream(int parameterIndex, InputStream x, int length) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setBinaryStream(int parameterIndex, InputStream x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setBinaryStream(int parameterIndex, InputStream x, int length) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setBinaryStream(int parameterIndex, InputStream x, long length) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setCharacterStream(int parameterIndex, Reader x) {
        try {
            this.setParameter(parameterIndex, CharStreams.toString((Readable)x));
        }
        catch (IOException ex) {
            throw new UnknownSQLException((Exception)ex);
        }
    }

    @Override
    public final void setCharacterStream(int parameterIndex, Reader x, int length) {
        try {
            this.setParameter(parameterIndex, CharStreams.toString((Readable)x));
        }
        catch (IOException ex) {
            throw new UnknownSQLException((Exception)ex);
        }
    }

    @Override
    public final void setCharacterStream(int parameterIndex, Reader x, long length) {
        try {
            this.setParameter(parameterIndex, CharStreams.toString((Readable)x));
        }
        catch (IOException ex) {
            throw new UnknownSQLException((Exception)ex);
        }
    }

    @Override
    public final void setURL(int parameterIndex, URL x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setSQLXML(int parameterIndex, SQLXML x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setObject(int parameterIndex, Object x) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setObject(int parameterIndex, Object x, int targetSqlType) {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public final void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) {
        this.setParameter(parameterIndex, x);
    }

    private void setParameter(int parameterIndex, Object value) {
        if (this.parameters.size() == parameterIndex - 1) {
            this.parameters.add(value);
            return;
        }
        for (int i = this.parameters.size(); i <= parameterIndex - 1; ++i) {
            this.parameters.add(null);
        }
        this.parameters.set(parameterIndex - 1, value);
    }

    protected final void replaySetParameter(PreparedStatement preparedStatement, List<Object> params) throws SQLException {
        this.setParameterMethodInvocations.clear();
        this.addParameters(params);
        for (PreparedStatementInvocationReplayer each : this.setParameterMethodInvocations) {
            each.replayOn(preparedStatement);
        }
    }

    private void addParameters(List<Object> params) {
        int i = 0;
        for (Object each : params) {
            int index = ++i;
            this.setParameterMethodInvocations.add(preparedStatement -> preparedStatement.setObject(index, each));
        }
    }

    @Override
    public final void clearParameters() {
        this.parameters.clear();
        this.setParameterMethodInvocations.clear();
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }

    @FunctionalInterface
    private static interface PreparedStatementInvocationReplayer {
        public void replayOn(PreparedStatement var1) throws SQLException;
    }
}

