/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.metrics;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.metrics.impl.DummyVertxMetrics;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.util.Map;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.vertx.metrics.DefaultHttpClientMetrics;
import org.apache.servicecomb.foundation.vertx.metrics.DefaultHttpServerMetrics;
import org.apache.servicecomb.foundation.vertx.metrics.DefaultTcpClientMetrics;
import org.apache.servicecomb.foundation.vertx.metrics.DefaultTcpServerMetrics;
import org.apache.servicecomb.foundation.vertx.metrics.MetricsOptionsEx;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultClientEndpointMetricManager;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultServerEndpointMetric;

public class DefaultVertxMetrics
extends DummyVertxMetrics {
    private final Map<String, DefaultServerEndpointMetric> serverEndpointMetricMap = new ConcurrentHashMapEx();
    private final DefaultClientEndpointMetricManager clientEndpointMetricManager;

    public DefaultVertxMetrics(VertxOptions vertxOptions) {
        this.clientEndpointMetricManager = new DefaultClientEndpointMetricManager((MetricsOptionsEx)vertxOptions.getMetricsOptions());
    }

    public DefaultClientEndpointMetricManager getClientEndpointMetricManager() {
        return this.clientEndpointMetricManager;
    }

    public Map<String, DefaultServerEndpointMetric> getServerEndpointMetricMap() {
        return this.serverEndpointMetricMap;
    }

    public HttpServerMetrics<?, ?, ?> createHttpServerMetrics(HttpServerOptions options, SocketAddress localAddress) {
        DefaultServerEndpointMetric endpointMetric = this.serverEndpointMetricMap.computeIfAbsent(localAddress.toString(), DefaultServerEndpointMetric::new);
        return new DefaultHttpServerMetrics(endpointMetric);
    }

    public HttpClientMetrics<?, ?, ?, ?> createHttpClientMetrics(HttpClientOptions options) {
        return new DefaultHttpClientMetrics(this.clientEndpointMetricManager);
    }

    public TCPMetrics<?> createNetServerMetrics(NetServerOptions options, SocketAddress localAddress) {
        DefaultServerEndpointMetric endpointMetric = this.serverEndpointMetricMap.computeIfAbsent(localAddress.toString(), DefaultServerEndpointMetric::new);
        return new DefaultTcpServerMetrics(endpointMetric);
    }

    public TCPMetrics<?> createNetClientMetrics(NetClientOptions options) {
        return new DefaultTcpClientMetrics(this.clientEndpointMetricManager);
    }

    public boolean isMetricsEnabled() {
        return true;
    }

    public void setVertx(Vertx vertx) {
        this.clientEndpointMetricManager.setVertx(vertx);
    }
}

