/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.ch.qos.logback.classic.joran;

import org.apache.rocketmq.shaded.ch.qos.logback.classic.joran.ModelClassToModelHandlerLinker;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.joran.action.ConfigurationAction;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.joran.action.ConsolePluginAction;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.joran.action.ContextNameAction;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.joran.action.InsertFromJNDIAction;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.joran.action.LevelAction;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.joran.action.LoggerAction;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.joran.action.LoggerContextListenerAction;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.joran.action.ReceiverAction;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.joran.action.RootLoggerAction;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.joran.sanity.IfNestedWithinSecondPhaseElementSC;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.model.processor.ConfigurationModelHandlerFull;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.model.processor.LogbackClassicDefaultNestedComponentRules;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.spi.ILoggingEvent;
import org.apache.rocketmq.shaded.ch.qos.logback.core.joran.JoranConfiguratorBase;
import org.apache.rocketmq.shaded.ch.qos.logback.core.joran.action.AppenderRefAction;
import org.apache.rocketmq.shaded.ch.qos.logback.core.joran.action.IncludeAction;
import org.apache.rocketmq.shaded.ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import org.apache.rocketmq.shaded.ch.qos.logback.core.joran.spi.ElementSelector;
import org.apache.rocketmq.shaded.ch.qos.logback.core.joran.spi.RuleStore;
import org.apache.rocketmq.shaded.ch.qos.logback.core.model.Model;
import org.apache.rocketmq.shaded.ch.qos.logback.core.model.processor.DefaultProcessor;

public class JoranConfigurator
extends JoranConfiguratorBase<ILoggingEvent> {
    @Override
    public void addElementSelectorAndActionAssociations(RuleStore rs) {
        super.addElementSelectorAndActionAssociations(rs);
        rs.addRule(new ElementSelector("configuration"), () -> new ConfigurationAction());
        rs.addRule(new ElementSelector("configuration/contextName"), () -> new ContextNameAction());
        rs.addRule(new ElementSelector("configuration/contextListener"), () -> new LoggerContextListenerAction());
        rs.addRule(new ElementSelector("configuration/insertFromJNDI"), () -> new InsertFromJNDIAction());
        rs.addRule(new ElementSelector("configuration/logger"), () -> new LoggerAction());
        rs.addRule(new ElementSelector("configuration/logger/level"), () -> new LevelAction());
        rs.addRule(new ElementSelector("configuration/root"), () -> new RootLoggerAction());
        rs.addRule(new ElementSelector("configuration/root/level"), () -> new LevelAction());
        rs.addRule(new ElementSelector("configuration/logger/appender-ref"), () -> new AppenderRefAction());
        rs.addRule(new ElementSelector("configuration/root/appender-ref"), () -> new AppenderRefAction());
        rs.addRule(new ElementSelector("configuration/include"), () -> new IncludeAction());
        rs.addRule(new ElementSelector("configuration/consolePlugin"), () -> new ConsolePluginAction());
        rs.addRule(new ElementSelector("configuration/receiver"), () -> new ReceiverAction());
    }

    @Override
    protected void sanityCheck(Model topModel) {
        super.sanityCheck(topModel);
        this.performCheck(new IfNestedWithinSecondPhaseElementSC(), topModel);
    }

    @Override
    protected void addDefaultNestedComponentRegistryRules(DefaultNestedComponentRegistry registry) {
        LogbackClassicDefaultNestedComponentRules.addDefaultNestedComponentRegistryRules(registry);
    }

    @Override
    protected void addModelHandlerAssociations(DefaultProcessor defaultProcessor) {
        ModelClassToModelHandlerLinker m4 = new ModelClassToModelHandlerLinker(this.context);
        m4.setConfigurationModelHandlerFactoryMethod(ConfigurationModelHandlerFull::makeInstance2);
        m4.link(defaultProcessor);
    }

    private void sealModelFilters(DefaultProcessor defaultProcessor) {
        defaultProcessor.getPhaseOneFilter().denyAll();
        defaultProcessor.getPhaseTwoFilter().allowAll();
    }
}

