/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.apis;

import java.time.Duration;
import java.util.Optional;
import org.apache.rocketmq.client.apis.ClientConfigurationBuilder;
import org.apache.rocketmq.client.apis.SessionCredentialsProvider;

public class ClientConfiguration {
    private final String endpoints;
    private final SessionCredentialsProvider sessionCredentialsProvider;
    private final Duration requestTimeout;
    private final boolean sslEnabled;
    private final String namespace;

    ClientConfiguration(String endpoints, SessionCredentialsProvider sessionCredentialsProvider, Duration requestTimeout, boolean sslEnabled, String namespace) {
        this.endpoints = endpoints;
        this.sessionCredentialsProvider = sessionCredentialsProvider;
        this.requestTimeout = requestTimeout;
        this.sslEnabled = sslEnabled;
        this.namespace = namespace;
    }

    public static ClientConfigurationBuilder newBuilder() {
        return new ClientConfigurationBuilder();
    }

    public String getEndpoints() {
        return this.endpoints;
    }

    public Optional<SessionCredentialsProvider> getCredentialsProvider() {
        return Optional.ofNullable(this.sessionCredentialsProvider);
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

