/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.protocol;

import java.util.HashMap;
import java.util.Map;

public enum DLedgerRequestCode {
    UNKNOWN(-1, ""),
    METADATA(50000, ""),
    APPEND(50001, ""),
    GET(50002, ""),
    VOTE(51001, ""),
    HEART_BEAT(51002, ""),
    PULL(51003, ""),
    PUSH(51004, ""),
    LEADERSHIP_TRANSFER(51005, "");

    private static Map<Integer, DLedgerRequestCode> codeMap;
    private int code;
    private String desc;

    private DLedgerRequestCode(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DLedgerRequestCode valueOf(int code) {
        DLedgerRequestCode tmp = codeMap.get(code);
        if (tmp != null) {
            return tmp;
        }
        return UNKNOWN;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String toString() {
        return String.format("[code=%d,name=%s,desc=%s]", this.code, this.name(), this.desc);
    }

    static {
        codeMap = new HashMap<Integer, DLedgerRequestCode>();
        for (DLedgerRequestCode requestCode : DLedgerRequestCode.values()) {
            codeMap.put(requestCode.code, requestCode);
        }
    }
}

