/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.auth.authorization.model;

import com.alibaba.fastjson2.annotation.JSONField;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.resource.ResourcePattern;
import org.apache.rocketmq.common.resource.ResourceType;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;

public class Resource {
    private ResourceType resourceType;
    private String resourceName;
    private ResourcePattern resourcePattern;

    public static Resource ofCluster(String clusterName) {
        return Resource.of(ResourceType.CLUSTER, clusterName, ResourcePattern.LITERAL);
    }

    public static Resource ofTopic(String topicName) {
        return Resource.of(ResourceType.TOPIC, topicName, ResourcePattern.LITERAL);
    }

    public static Resource ofGroup(String groupName) {
        if (NamespaceUtil.isRetryTopic((String)groupName)) {
            groupName = NamespaceUtil.withOutRetryAndDLQ((String)groupName);
        }
        return Resource.of(ResourceType.GROUP, groupName, ResourcePattern.LITERAL);
    }

    public static Resource of(ResourceType resourceType, String resourceName, ResourcePattern resourcePattern) {
        Resource resource = new Resource();
        resource.resourceType = resourceType;
        resource.resourceName = resourceName;
        resource.resourcePattern = resourcePattern;
        return resource;
    }

    public static List<Resource> of(List<String> resourceKeys) {
        if (CollectionUtils.isEmpty(resourceKeys)) {
            return null;
        }
        return resourceKeys.stream().map(Resource::of).collect(Collectors.toList());
    }

    public static Resource of(String resourceKey) {
        if (StringUtils.isBlank((CharSequence)resourceKey)) {
            return null;
        }
        if (StringUtils.equals((CharSequence)resourceKey, (CharSequence)"*")) {
            return Resource.of(ResourceType.ANY, null, ResourcePattern.ANY);
        }
        String type = StringUtils.substringBefore((String)resourceKey, (String)":");
        ResourceType resourceType = ResourceType.getByName((String)type);
        if (resourceType == null) {
            return null;
        }
        String resourceName = StringUtils.substringAfter((String)resourceKey, (String)":");
        ResourcePattern resourcePattern = ResourcePattern.LITERAL;
        if (StringUtils.equals((CharSequence)resourceName, (CharSequence)"*")) {
            resourceName = null;
            resourcePattern = ResourcePattern.ANY;
        } else if (StringUtils.endsWith((CharSequence)resourceName, (CharSequence)"*")) {
            resourceName = StringUtils.substringBefore((String)resourceName, (String)"*");
            resourcePattern = ResourcePattern.PREFIXED;
        }
        return Resource.of(resourceType, resourceName, resourcePattern);
    }

    @JSONField(serialize=false)
    public String getResourceKey() {
        if (this.resourceType == ResourceType.ANY) {
            return "*";
        }
        switch (this.resourcePattern) {
            case ANY: {
                return this.resourceType.getName() + ":" + "*";
            }
            case LITERAL: {
                return this.resourceType.getName() + ":" + this.resourceName;
            }
            case PREFIXED: {
                return this.resourceType.getName() + ":" + this.resourceName + "*";
            }
        }
        return null;
    }

    public boolean isMatch(Resource resource) {
        if (this.resourceType == ResourceType.ANY) {
            return true;
        }
        if (this.resourceType != resource.resourceType) {
            return false;
        }
        switch (this.resourcePattern) {
            case ANY: {
                return true;
            }
            case LITERAL: {
                return StringUtils.equals((CharSequence)resource.resourceName, (CharSequence)this.resourceName);
            }
            case PREFIXED: {
                return StringUtils.startsWith((CharSequence)resource.resourceName, (CharSequence)this.resourceName);
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        return this.resourceType == resource.resourceType && Objects.equals(this.resourceName, resource.resourceName) && this.resourcePattern == resource.resourcePattern;
    }

    public int hashCode() {
        return Objects.hash(this.resourceType, this.resourceName, this.resourcePattern);
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public ResourcePattern getResourcePattern() {
        return this.resourcePattern;
    }

    public void setResourcePattern(ResourcePattern resourcePattern) {
        this.resourcePattern = resourcePattern;
    }
}

