/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Iterator;
import com.alipay.sofa.jraft.StateMachine;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.LeaderChangeContext;
import com.alipay.sofa.jraft.entity.NodeId;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.error.RaftException;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import com.alipay.sofa.jraft.util.Utils;
import io.opentelemetry.api.common.AttributesBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.controller.elect.impl.DefaultElectPolicy;
import org.apache.rocketmq.controller.impl.closure.ControllerClosure;
import org.apache.rocketmq.controller.impl.event.ControllerResult;
import org.apache.rocketmq.controller.impl.manager.RaftReplicasInfoManager;
import org.apache.rocketmq.controller.impl.task.BrokerCloseChannelRequest;
import org.apache.rocketmq.controller.impl.task.CheckNotActiveBrokerRequest;
import org.apache.rocketmq.controller.impl.task.GetBrokerLiveInfoRequest;
import org.apache.rocketmq.controller.impl.task.GetSyncStateDataRequest;
import org.apache.rocketmq.controller.impl.task.RaftBrokerHeartBeatEventRequest;
import org.apache.rocketmq.controller.metrics.ControllerMetricsConstant;
import org.apache.rocketmq.controller.metrics.ControllerMetricsManager;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.body.SyncStateSet;
import org.apache.rocketmq.remoting.protocol.header.controller.AlterSyncStateSetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.AlterSyncStateSetResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.admin.CleanControllerBrokerDataRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.ApplyBrokerIdRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.ApplyBrokerIdResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.GetNextBrokerIdRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.GetNextBrokerIdResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.RegisterBrokerToControllerRequestHeader;

public class JRaftControllerStateMachine
implements StateMachine {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqController");
    private final List<Consumer<Long>> onLeaderStartCallbacks;
    private final List<Consumer<Status>> onLeaderStopCallbacks;
    private final RaftReplicasInfoManager replicasInfoManager;
    private final NodeId nodeId;

    public JRaftControllerStateMachine(ControllerConfig controllerConfig, NodeId nodeId) {
        this.replicasInfoManager = new RaftReplicasInfoManager(controllerConfig);
        this.nodeId = nodeId;
        this.onLeaderStartCallbacks = new ArrayList<Consumer<Long>>();
        this.onLeaderStopCallbacks = new ArrayList<Consumer<Status>>();
    }

    public void onApply(Iterator iter) {
        while (iter.hasNext()) {
            byte[] data = iter.getData().array();
            ControllerClosure controllerClosure = (ControllerClosure)iter.done();
            this.processEvent(controllerClosure, data, iter.getTerm(), iter.getIndex());
            iter.next();
        }
    }

    private void processEvent(ControllerClosure controllerClosure, byte[] data, long term, long index) {
        ControllerResult<Object> result;
        RemotingCommand request;
        try {
            request = controllerClosure != null ? controllerClosure.getRequestEvent() : RemotingCommand.decode((byte[])Arrays.copyOfRange(data, 4, data.length));
            log.info("process event: term {}, index {}, request code {}", new Object[]{term, index, request.getCode()});
            switch (request.getCode()) {
                case 1001: {
                    AlterSyncStateSetRequestHeader requestHeader = (AlterSyncStateSetRequestHeader)request.decodeCommandCustomHeader(AlterSyncStateSetRequestHeader.class);
                    SyncStateSet syncStateSet = (SyncStateSet)RemotingSerializable.decode((byte[])request.getBody(), SyncStateSet.class);
                    result = this.alterSyncStateSet(requestHeader, syncStateSet);
                    break;
                }
                case 1002: {
                    ElectMasterRequestHeader electMasterRequestHeader = (ElectMasterRequestHeader)request.decodeCommandCustomHeader(ElectMasterRequestHeader.class);
                    result = this.electMaster(electMasterRequestHeader);
                    break;
                }
                case 1012: {
                    GetNextBrokerIdRequestHeader getNextBrokerIdRequestHeader = (GetNextBrokerIdRequestHeader)request.decodeCommandCustomHeader(GetNextBrokerIdRequestHeader.class);
                    result = this.getNextBrokerId(getNextBrokerIdRequestHeader);
                    break;
                }
                case 1013: {
                    ApplyBrokerIdRequestHeader applyBrokerIdRequestHeader = (ApplyBrokerIdRequestHeader)request.decodeCommandCustomHeader(ApplyBrokerIdRequestHeader.class);
                    result = this.applyBrokerId(applyBrokerIdRequestHeader);
                    break;
                }
                case 1003: {
                    RegisterBrokerToControllerRequestHeader registerBrokerToControllerRequestHeader = (RegisterBrokerToControllerRequestHeader)request.decodeCommandCustomHeader(RegisterBrokerToControllerRequestHeader.class);
                    result = this.registerBroker(registerBrokerToControllerRequestHeader);
                    break;
                }
                case 1004: {
                    GetReplicaInfoRequestHeader getReplicaInfoRequestHeader = (GetReplicaInfoRequestHeader)request.decodeCommandCustomHeader(GetReplicaInfoRequestHeader.class);
                    result = this.getReplicaInfo(getReplicaInfoRequestHeader);
                    break;
                }
                case 1006: {
                    List brokerNames = (List)RemotingSerializable.decode((byte[])request.getBody(), List.class);
                    GetSyncStateDataRequest getSyncStateDataRequest = (GetSyncStateDataRequest)request.decodeCommandCustomHeader(GetSyncStateDataRequest.class);
                    result = this.getSyncStateData(brokerNames, getSyncStateDataRequest.getInvokeTime());
                    break;
                }
                case 1011: {
                    CleanControllerBrokerDataRequestHeader cleanBrokerDataRequestHeader = (CleanControllerBrokerDataRequestHeader)request.decodeCommandCustomHeader(CleanControllerBrokerDataRequestHeader.class);
                    result = this.cleanBrokerData(cleanBrokerDataRequestHeader);
                    break;
                }
                case 1016: {
                    GetBrokerLiveInfoRequest getBrokerLiveInfoRequest = (GetBrokerLiveInfoRequest)request.decodeCommandCustomHeader(GetBrokerLiveInfoRequest.class);
                    result = this.replicasInfoManager.getBrokerLiveInfo(getBrokerLiveInfoRequest);
                    break;
                }
                case 1018: {
                    RaftBrokerHeartBeatEventRequest brokerHeartbeatRequestHeader = (RaftBrokerHeartBeatEventRequest)request.decodeCommandCustomHeader(RaftBrokerHeartBeatEventRequest.class);
                    result = this.replicasInfoManager.onBrokerHeartBeat(brokerHeartbeatRequestHeader);
                    break;
                }
                case 1014: {
                    BrokerCloseChannelRequest brokerCloseChannelRequest = (BrokerCloseChannelRequest)request.decodeCommandCustomHeader(BrokerCloseChannelRequest.class);
                    result = this.replicasInfoManager.onBrokerCloseChannel(brokerCloseChannelRequest);
                    break;
                }
                case 1015: {
                    CheckNotActiveBrokerRequest checkNotActiveBrokerRequest = (CheckNotActiveBrokerRequest)request.decodeCommandCustomHeader(CheckNotActiveBrokerRequest.class);
                    result = this.replicasInfoManager.checkNotActiveBroker(checkNotActiveBrokerRequest);
                    break;
                }
                default: {
                    throw new RemotingCommandException("Unknown request code: " + request.getCode());
                }
            }
            result.getEvents().forEach(this.replicasInfoManager::applyEvent);
        }
        catch (RemotingCommandException e) {
            log.error("Fail to process event", (Throwable)e);
            if (controllerClosure != null) {
                controllerClosure.run(new Status(RaftError.EINTERNAL, e.getMessage(), new Object[0]));
            }
            return;
        }
        log.info("process event: term {}, index {}, request code {} success with result {}", new Object[]{term, index, request.getCode(), result.toString()});
        if (controllerClosure != null) {
            controllerClosure.setControllerResult(result);
            controllerClosure.run(Status.OK());
        }
    }

    private ControllerResult<AlterSyncStateSetResponseHeader> alterSyncStateSet(AlterSyncStateSetRequestHeader requestHeader, SyncStateSet syncStateSet) {
        return this.replicasInfoManager.alterSyncStateSet(requestHeader, syncStateSet, new RaftReplicasInfoManager.BrokerValidPredicateWithInvokeTime(requestHeader.getInvokeTime(), this.replicasInfoManager));
    }

    private ControllerResult<ElectMasterResponseHeader> electMaster(ElectMasterRequestHeader request) {
        ControllerResult<ElectMasterResponseHeader> electResult = this.replicasInfoManager.electMaster(request, new DefaultElectPolicy((clusterName, brokerName, brokerId) -> this.replicasInfoManager.isBrokerActive(clusterName, brokerName, brokerId, request.getInvokeTime()), this.replicasInfoManager::getBrokerLiveInfo));
        log.info("elect master, request :{}, result: {}", (Object)request.toString(), (Object)electResult.toString());
        AttributesBuilder attributesBuilder = ControllerMetricsManager.newAttributesBuilder().put("cluster", request.getClusterName()).put("broker_set", request.getBrokerName());
        switch (electResult.getResponseCode()) {
            case 0: {
                ControllerMetricsManager.electionTotal.add(1L, attributesBuilder.put("election_result", ControllerMetricsConstant.ElectionResult.NEW_MASTER_ELECTED.getLowerCaseName()).build());
                break;
            }
            case 2011: {
                ControllerMetricsManager.electionTotal.add(1L, attributesBuilder.put("election_result", ControllerMetricsConstant.ElectionResult.KEEP_CURRENT_MASTER.getLowerCaseName()).build());
                break;
            }
            case 2004: 
            case 2012: {
                ControllerMetricsManager.electionTotal.add(1L, attributesBuilder.put("election_result", ControllerMetricsConstant.ElectionResult.NO_MASTER_ELECTED.getLowerCaseName()).build());
                break;
            }
        }
        return electResult;
    }

    private ControllerResult<GetNextBrokerIdResponseHeader> getNextBrokerId(GetNextBrokerIdRequestHeader requestHeader) {
        return this.replicasInfoManager.getNextBrokerId(requestHeader);
    }

    private ControllerResult<ApplyBrokerIdResponseHeader> applyBrokerId(ApplyBrokerIdRequestHeader requestHeader) {
        return this.replicasInfoManager.applyBrokerId(requestHeader);
    }

    private ControllerResult<?> registerBroker(RegisterBrokerToControllerRequestHeader request) {
        return this.replicasInfoManager.registerBroker(request, new RaftReplicasInfoManager.BrokerValidPredicateWithInvokeTime(request.getInvokeTime(), this.replicasInfoManager));
    }

    private ControllerResult<GetReplicaInfoResponseHeader> getReplicaInfo(GetReplicaInfoRequestHeader request) {
        return this.replicasInfoManager.getReplicaInfo(request);
    }

    private ControllerResult<Void> getSyncStateData(List<String> brokerNames, long invokeTile) {
        return this.replicasInfoManager.getSyncStateData(brokerNames, new RaftReplicasInfoManager.BrokerValidPredicateWithInvokeTime(invokeTile, this.replicasInfoManager));
    }

    private ControllerResult<Void> cleanBrokerData(CleanControllerBrokerDataRequestHeader requestHeader) {
        return this.replicasInfoManager.cleanBrokerData(requestHeader, new RaftReplicasInfoManager.BrokerValidPredicateWithInvokeTime(requestHeader.getInvokeTime(), this.replicasInfoManager));
    }

    public void onShutdown() {
        log.info("StateMachine {} node {} onShutdown", (Object)this.getClass().getName(), (Object)this.nodeId.toString());
    }

    public void onSnapshotSave(SnapshotWriter writer, Closure done) {
        byte[] data;
        try {
            data = this.replicasInfoManager.serialize();
        }
        catch (Throwable e) {
            done.run(new Status(RaftError.EIO, "Fail to serialize replicasInfoManager state machine data", new Object[0]));
            return;
        }
        Utils.runInThread(() -> {
            try {
                FileUtils.writeByteArrayToFile((File)new File(writer.getPath() + File.separator + "data"), (byte[])data);
                if (!writer.addFile("data")) {
                    throw new IOException("Fail to add file to writer");
                }
                log.info("Save snapshot, path={}", (Object)writer.getPath());
                done.run(Status.OK());
            }
            catch (IOException e) {
                log.error("Fail to save snapshot", (Throwable)e);
                done.run(new Status(RaftError.EIO, "Fail to save snapshot", new Object[0]));
            }
        });
    }

    public boolean onSnapshotLoad(SnapshotReader reader) {
        if (reader.getFileMeta("data") == null) {
            log.error("Fail to find data file in {}", (Object)reader.getPath());
            return false;
        }
        try {
            byte[] data = FileUtils.readFileToByteArray((File)new File(reader.getPath() + File.separator + "data"));
            this.replicasInfoManager.deserializeFrom(data);
            log.info("Load snapshot from {}", (Object)reader.getPath());
            return true;
        }
        catch (Throwable e) {
            log.error("Fail to load snapshot from {}", (Object)reader.getPath(), (Object)e);
            return false;
        }
    }

    public void onLeaderStart(long term) {
        for (Consumer<Long> callback : this.onLeaderStartCallbacks) {
            callback.accept(term);
        }
        log.info("node {} Start Leader, term={}", (Object)this.nodeId.toString(), (Object)term);
    }

    public void onLeaderStop(Status status) {
        for (Consumer<Status> callback : this.onLeaderStopCallbacks) {
            callback.accept(status);
        }
        log.info("node {} Stop Leader, status={}", (Object)this.nodeId.toString(), (Object)status);
    }

    public void registerOnLeaderStart(Consumer<Long> callback) {
        this.onLeaderStartCallbacks.add(callback);
    }

    public void registerOnLeaderStop(Consumer<Status> callback) {
        this.onLeaderStopCallbacks.add(callback);
    }

    public void onError(RaftException e) {
        log.error("Encountered an error={} on StateMachine {}, node {}, raft may stop working since some error occurs, you should figure out the cause and repair or remove this node.", new Object[]{e.getStatus(), this.getClass().getName(), this.nodeId.toString(), e});
    }

    public void onConfigurationCommitted(Configuration conf) {
        log.info("Configuration committed, conf={}", (Object)conf);
    }

    public void onStopFollowing(LeaderChangeContext ctx) {
        log.info("Stop following, ctx={}", (Object)ctx);
    }

    public void onStartFollowing(LeaderChangeContext ctx) {
        log.info("Start following, ctx={}", (Object)ctx);
    }
}

