/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.transaction.queue;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;

public class TransactionalMessageUtil {
    public static final String REMOVE_TAG = "d";
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final String OFFSET_SEPARATOR = ",";
    public static final String TRANSACTION_ID = "__transactionId__";

    public static String buildOpTopic() {
        return "RMQ_SYS_TRANS_OP_HALF_TOPIC";
    }

    public static String buildHalfTopic() {
        return "RMQ_SYS_TRANS_HALF_TOPIC";
    }

    public static String buildConsumerGroup() {
        return "CID_RMQ_SYS_TRANS";
    }

    public static MessageExtBrokerInner buildTransactionalMessageFromHalfMessage(MessageExt msgExt) {
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setWaitStoreMsgOK(false);
        msgInner.setMsgId(msgExt.getMsgId());
        msgInner.setTopic(msgExt.getProperty("REAL_TOPIC"));
        msgInner.setBody(msgExt.getBody());
        String realQueueIdStr = msgExt.getProperty("REAL_QID");
        if (StringUtils.isNumeric((CharSequence)realQueueIdStr)) {
            msgInner.setQueueId(Integer.parseInt(realQueueIdStr));
        }
        msgInner.setFlag(msgExt.getFlag());
        msgInner.setTagsCode(MessageExtBrokerInner.tagsString2tagsCode((String)msgInner.getTags()));
        msgInner.setBornTimestamp(msgExt.getBornTimestamp());
        msgInner.setBornHost(msgExt.getBornHost());
        msgInner.setTransactionId(msgExt.getProperty("UNIQ_KEY"));
        MessageAccessor.setProperties((Message)msgInner, (Map)msgExt.getProperties());
        MessageAccessor.putProperty((Message)msgInner, (String)"TRAN_MSG", (String)"true");
        MessageAccessor.clearProperty((Message)msgInner, (String)"TRAN_PREPARED_QUEUE_OFFSET");
        MessageAccessor.clearProperty((Message)msgInner, (String)"REAL_QID");
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        int sysFlag = msgExt.getSysFlag();
        msgInner.setSysFlag(sysFlag |= 4);
        return msgInner;
    }

    public static long getImmunityTime(String checkImmunityTimeStr, long transactionTimeout) {
        long checkImmunityTime = 0L;
        try {
            checkImmunityTime = Long.parseLong(checkImmunityTimeStr) * 1000L;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (checkImmunityTime < transactionTimeout) {
            checkImmunityTime = transactionTimeout;
        }
        return checkImmunityTime;
    }
}

