/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.transaction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class TransactionMetrics
extends ConfigManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private ConcurrentMap<String, Metric> transactionCounts = new ConcurrentHashMap<String, Metric>(1024);
    private DataVersion dataVersion = new DataVersion();
    private final String configPath;

    public TransactionMetrics(String configPath) {
        this.configPath = configPath;
    }

    public long addAndGet(String topic, int value) {
        Metric pair = this.getTopicPair(topic);
        this.getDataVersion().nextVersion();
        pair.setTimeStamp(System.currentTimeMillis());
        return pair.getCount().addAndGet(value);
    }

    public Metric getTopicPair(String topic) {
        Metric pair = (Metric)this.transactionCounts.get(topic);
        if (null != pair) {
            return pair;
        }
        pair = new Metric();
        Metric previous = this.transactionCounts.putIfAbsent(topic, pair);
        if (null != previous) {
            return previous;
        }
        return pair;
    }

    public long getTransactionCount(String topic) {
        Metric pair = (Metric)this.transactionCounts.get(topic);
        if (null == pair) {
            return 0L;
        }
        return pair.getCount().get();
    }

    public Map<String, Metric> getTransactionCounts() {
        return this.transactionCounts;
    }

    public void setTransactionCounts(ConcurrentMap<String, Metric> transactionCounts) {
        this.transactionCounts = transactionCounts;
    }

    protected void write0(Writer writer) {
        TransactionMetricsSerializeWrapper wrapper = new TransactionMetricsSerializeWrapper();
        wrapper.setTransactionCount(this.transactionCounts);
        wrapper.setDataVersion(this.dataVersion);
        JSON.writeJSONString((Writer)writer, (Object)((Object)wrapper), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible});
    }

    public String encode() {
        return this.encode(false);
    }

    public String configFilePath() {
        return this.configPath;
    }

    public void decode(String jsonString) {
        TransactionMetricsSerializeWrapper transactionMetricsSerializeWrapper;
        if (jsonString != null && (transactionMetricsSerializeWrapper = (TransactionMetricsSerializeWrapper)((Object)TransactionMetricsSerializeWrapper.fromJson((String)jsonString, TransactionMetricsSerializeWrapper.class))) != null) {
            this.transactionCounts.putAll(transactionMetricsSerializeWrapper.getTransactionCount());
            this.dataVersion.assignNewOne(transactionMetricsSerializeWrapper.getDataVersion());
        }
    }

    public String encode(boolean prettyFormat) {
        TransactionMetricsSerializeWrapper metricsSerializeWrapper = new TransactionMetricsSerializeWrapper();
        metricsSerializeWrapper.setDataVersion(this.dataVersion);
        metricsSerializeWrapper.setTransactionCount(this.transactionCounts);
        return metricsSerializeWrapper.toJson(prettyFormat);
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public void setDataVersion(DataVersion dataVersion) {
        this.dataVersion = dataVersion;
    }

    public void cleanMetrics(Set<String> topics) {
        if (topics == null || topics.isEmpty()) {
            return;
        }
        Iterator iterator = this.transactionCounts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String topic = (String)entry.getKey();
            if (topic.startsWith("rmq_sys_") || !topics.contains(topic)) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void persist() {
        String config = this.configFilePath();
        String temp = config + ".tmp";
        String backup = config + ".bak";
        BufferedWriter bufferedWriter = null;
        try {
            File tmpFile = new File(temp);
            File parentDirectory = tmpFile.getParentFile();
            if (!parentDirectory.exists() && !parentDirectory.mkdirs()) {
                log.error("Failed to create directory: {}", (Object)parentDirectory.getCanonicalPath());
                return;
            }
            if (!tmpFile.exists() && !tmpFile.createNewFile()) {
                log.error("Failed to create file: {}", (Object)tmpFile.getCanonicalPath());
                return;
            }
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile, false), StandardCharsets.UTF_8));
            this.write0(bufferedWriter);
            bufferedWriter.flush();
            bufferedWriter.close();
            log.debug("Finished writing tmp file: {}", (Object)temp);
            File configFile = new File(config);
            if (configFile.exists()) {
                Files.copy((File)configFile, (File)new File(backup));
                configFile.delete();
            }
            tmpFile.renameTo(configFile);
            return;
        }
        catch (IOException e) {
            log.error("Failed to persist {}", (Object)temp, (Object)e);
            return;
        }
        finally {
            if (null != bufferedWriter) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class Metric {
        private AtomicLong count = new AtomicLong(0L);
        private long timeStamp = System.currentTimeMillis();

        public AtomicLong getCount() {
            return this.count;
        }

        public void setCount(AtomicLong count) {
            this.count = count;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public String toString() {
            return String.format("[%d,%d]", this.count.get(), this.timeStamp);
        }
    }

    public static class TransactionMetricsSerializeWrapper
    extends RemotingSerializable {
        private ConcurrentMap<String, Metric> transactionCount = new ConcurrentHashMap<String, Metric>(1024);
        private DataVersion dataVersion = new DataVersion();

        public ConcurrentMap<String, Metric> getTransactionCount() {
            return this.transactionCount;
        }

        public void setTransactionCount(ConcurrentMap<String, Metric> transactionCount) {
            this.transactionCount = transactionCount;
        }

        public DataVersion getDataVersion() {
            return this.dataVersion;
        }

        public void setDataVersion(DataVersion dataVersion) {
            this.dataVersion = dataVersion;
        }
    }
}

