/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.pop;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.common.KeyBuilder;
import org.apache.rocketmq.common.utils.ConcurrentHashMapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopConsumerLockService {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqPop");
    private final long timeout;
    private final ConcurrentMap<String, TimedLock> lockTable;

    public PopConsumerLockService(long timeout) {
        this.timeout = timeout;
        this.lockTable = new ConcurrentHashMap<String, TimedLock>();
    }

    public boolean tryLock(String groupId, String topicId) {
        return ((TimedLock)Objects.requireNonNull(ConcurrentHashMapUtils.computeIfAbsent(this.lockTable, (Object)(groupId + "@" + topicId), s -> new TimedLock()))).tryLock();
    }

    public void unlock(String groupId, String topicId) {
        TimedLock lock = (TimedLock)this.lockTable.get(groupId + "@" + topicId);
        if (lock != null) {
            lock.unlock();
        }
    }

    public boolean isLockTimeout(String groupId, String topicId) {
        topicId = KeyBuilder.parseNormalTopic((String)topicId, (String)groupId);
        TimedLock lock = (TimedLock)this.lockTable.get(groupId + "@" + topicId);
        return lock == null || System.currentTimeMillis() - lock.getLockTime() > this.timeout;
    }

    public void removeTimeout() {
        Iterator iterator = this.lockTable.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (System.currentTimeMillis() - ((TimedLock)entry.getValue()).getLockTime() <= this.timeout) continue;
            log.info("PopConsumerLockService remove timeout lock, key={}, locked={}", entry.getKey(), (Object)((TimedLock)entry.getValue()).lock.get());
            iterator.remove();
        }
    }

    static class TimedLock {
        private volatile long lockTime = System.currentTimeMillis();
        private final AtomicBoolean lock = new AtomicBoolean(false);

        public boolean tryLock() {
            if (this.lock.compareAndSet(false, true)) {
                this.lockTime = System.currentTimeMillis();
                return true;
            }
            return false;
        }

        public void unlock() {
            this.lock.set(false);
        }

        public long getLockTime() {
            return this.lockTime;
        }
    }
}

