/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc;

import com.alipay.remoting.AbstractLifeCycle;
import com.alipay.remoting.LifeCycleException;
import com.alipay.remoting.NamedThreadFactory;
import com.alipay.remoting.Scannable;
import com.alipay.remoting.log.BoltLoggerFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class RpcTaskScanner
extends AbstractLifeCycle {
    private static final Logger logger = BoltLoggerFactory.getLogger("RpcRemoting");
    private final List<Scannable> scanList = new LinkedList<Scannable>();
    private ScheduledExecutorService scheduledService;

    @Override
    public void startup() throws LifeCycleException {
        super.startup();
        this.scheduledService = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("RpcTaskScannerThread", true));
        this.scheduledService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                for (Scannable scanned : RpcTaskScanner.this.scanList) {
                    try {
                        scanned.scan();
                    }
                    catch (Throwable t) {
                        logger.error("Exception caught when scannings.", t);
                    }
                }
            }
        }, 10000L, 10000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() throws LifeCycleException {
        super.shutdown();
        this.scheduledService.shutdown();
    }

    @Deprecated
    public void start() {
        this.startup();
    }

    public void add(Scannable target) {
        this.scanList.add(target);
    }
}

