/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.connection;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventHandler;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.ExtendedNettyChannelHandler;
import com.alipay.remoting.NamedThreadFactory;
import com.alipay.remoting.ProtocolCode;
import com.alipay.remoting.Url;
import com.alipay.remoting.codec.Codec;
import com.alipay.remoting.config.BoltClientOption;
import com.alipay.remoting.config.BoltGenericOption;
import com.alipay.remoting.config.BoltServerOption;
import com.alipay.remoting.config.ConfigManager;
import com.alipay.remoting.config.Configuration;
import com.alipay.remoting.connection.ConnectionFactory;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.rpc.RpcConfigManager;
import com.alipay.remoting.util.IoUtils;
import com.alipay.remoting.util.NettyEventLoopUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.FileInputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyStore;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;

public abstract class AbstractConnectionFactory
implements ConnectionFactory {
    private static final Logger logger = BoltLoggerFactory.getLogger(AbstractConnectionFactory.class);
    private static final EventLoopGroup workerGroup = NettyEventLoopUtil.newEventLoopGroup(Runtime.getRuntime().availableProcessors() + 1, new NamedThreadFactory("bolt-netty-client-worker", true));
    private final Configuration configuration;
    private final Codec codec;
    private final ChannelHandler heartbeatHandler;
    private final ChannelHandler handler;
    protected Bootstrap bootstrap;

    public AbstractConnectionFactory(Codec codec, ChannelHandler heartbeatHandler, ChannelHandler handler, Configuration configuration) {
        if (codec == null) {
            throw new IllegalArgumentException("null codec");
        }
        if (handler == null) {
            throw new IllegalArgumentException("null handler");
        }
        this.configuration = configuration;
        this.codec = codec;
        this.heartbeatHandler = heartbeatHandler;
        this.handler = handler;
    }

    @Override
    public void init(final ConnectionEventHandler connectionEventHandler) {
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(workerGroup)).channel(NettyEventLoopUtil.getClientSocketChannelClass())).option(ChannelOption.TCP_NODELAY, (Object)ConfigManager.tcp_nodelay())).option(ChannelOption.SO_REUSEADDR, (Object)ConfigManager.tcp_so_reuseaddr())).option(ChannelOption.SO_KEEPALIVE, (Object)ConfigManager.tcp_so_keepalive())).option(ChannelOption.SO_SNDBUF, (Object)ConfigManager.tcp_so_sndbuf())).option(ChannelOption.SO_RCVBUF, (Object)ConfigManager.tcp_so_rcvbuf());
        this.initWriteBufferWaterMark();
        if (ConfigManager.netty_buffer_pooled()) {
            this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        } else {
            this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)UnpooledByteBufAllocator.DEFAULT);
        }
        final boolean flushConsolidationSwitch = (Boolean)this.configuration.option(BoltClientOption.NETTY_FLUSH_CONSOLIDATION);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) {
                List<ChannelHandler> backHandlers;
                Boolean sslEnable;
                List<ChannelHandler> frontHandlers;
                ChannelPipeline pipeline = channel.pipeline();
                ExtendedNettyChannelHandler extendedHandlers = (ExtendedNettyChannelHandler)AbstractConnectionFactory.this.configuration.option(BoltClientOption.EXTENDED_NETTY_CHANNEL_HANDLER);
                if (extendedHandlers != null && (frontHandlers = extendedHandlers.frontChannelHandlers()) != null) {
                    for (ChannelHandler channelHandler : frontHandlers) {
                        pipeline.addLast(channelHandler.getClass().getName(), channelHandler);
                    }
                }
                if (!(sslEnable = AbstractConnectionFactory.this.configuration.option(BoltClientOption.CLI_SSL_ENABLE)).booleanValue()) {
                    sslEnable = RpcConfigManager.client_ssl_enable();
                }
                if (sslEnable.booleanValue()) {
                    SSLEngine engine = AbstractConnectionFactory.this.initSSLContext().newEngine(channel.alloc());
                    engine.setUseClientMode(true);
                    pipeline.addLast("sslHandler", (ChannelHandler)new SslHandler(engine));
                }
                if (flushConsolidationSwitch) {
                    pipeline.addLast("flushConsolidationHandler", (ChannelHandler)new FlushConsolidationHandler(1024, true));
                }
                pipeline.addLast("decoder", AbstractConnectionFactory.this.codec.newDecoder());
                pipeline.addLast("encoder", AbstractConnectionFactory.this.codec.newEncoder());
                boolean idleSwitch = ConfigManager.tcp_idle_switch();
                if (idleSwitch) {
                    pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler((long)ConfigManager.tcp_idle(), (long)ConfigManager.tcp_idle(), 0L, TimeUnit.MILLISECONDS));
                    pipeline.addLast("heartbeatHandler", AbstractConnectionFactory.this.heartbeatHandler);
                }
                pipeline.addLast("connectionEventHandler", (ChannelHandler)connectionEventHandler);
                pipeline.addLast("handler", AbstractConnectionFactory.this.handler);
                if (extendedHandlers != null && (backHandlers = extendedHandlers.backChannelHandlers()) != null) {
                    for (ChannelHandler channelHandler : backHandlers) {
                        pipeline.addLast(channelHandler.getClass().getName(), channelHandler);
                    }
                }
            }
        });
    }

    @Override
    public Connection createConnection(Url url) throws Exception {
        Channel channel = this.doCreateConnection(url.getIp(), url.getPort(), url.getConnectTimeout());
        Connection conn = new Connection(channel, ProtocolCode.fromBytes(url.getProtocol()), url.getVersion(), url);
        if (channel.isActive()) {
            channel.pipeline().fireUserEventTriggered((Object)ConnectionEventType.CONNECT);
        } else {
            channel.pipeline().fireUserEventTriggered((Object)ConnectionEventType.CONNECT_FAILED);
        }
        return conn;
    }

    @Override
    public Connection createConnection(String targetIP, int targetPort, int connectTimeout) throws Exception {
        Channel channel = this.doCreateConnection(targetIP, targetPort, connectTimeout);
        Connection conn = new Connection(channel, ProtocolCode.fromBytes(1), 1, new Url(targetIP, targetPort));
        if (channel.isActive()) {
            channel.pipeline().fireUserEventTriggered((Object)ConnectionEventType.CONNECT);
        } else {
            channel.pipeline().fireUserEventTriggered((Object)ConnectionEventType.CONNECT_FAILED);
        }
        return conn;
    }

    @Override
    public Connection createConnection(String targetIP, int targetPort, byte version, int connectTimeout) throws Exception {
        Channel channel = this.doCreateConnection(targetIP, targetPort, connectTimeout);
        Connection conn = new Connection(channel, ProtocolCode.fromBytes(2), version, new Url(targetIP, targetPort));
        if (channel.isActive()) {
            channel.pipeline().fireUserEventTriggered((Object)ConnectionEventType.CONNECT);
        } else {
            channel.pipeline().fireUserEventTriggered((Object)ConnectionEventType.CONNECT_FAILED);
        }
        return conn;
    }

    private void initWriteBufferWaterMark() {
        int highWaterMark;
        int lowWaterMark;
        Integer highWaterMarkConfig;
        Integer lowWaterMarkConfig = ConfigManager.netty_buffer_low_watermark();
        if (lowWaterMarkConfig != null) {
            this.configuration.option(BoltServerOption.NETTY_BUFFER_LOW_WATER_MARK, lowWaterMarkConfig);
        }
        if ((highWaterMarkConfig = ConfigManager.netty_buffer_high_watermark()) != null) {
            this.configuration.option(BoltServerOption.NETTY_BUFFER_HIGH_WATER_MARK, highWaterMarkConfig);
        }
        if ((lowWaterMark = this.configuration.option(BoltGenericOption.NETTY_BUFFER_LOW_WATER_MARK).intValue()) > (highWaterMark = this.configuration.option(BoltGenericOption.NETTY_BUFFER_HIGH_WATER_MARK).intValue())) {
            throw new IllegalArgumentException(String.format("[client side] bolt netty high water mark {%s} should not be smaller than low water mark {%s} bytes)", highWaterMark, lowWaterMark));
        }
        logger.warn("[client side] bolt netty low water mark is {} bytes, high water mark is {} bytes", (Object)lowWaterMark, (Object)highWaterMark);
        this.bootstrap.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(lowWaterMark, highWaterMark));
    }

    private SslContext initSSLContext() {
        SslContext sslContext;
        FileInputStream in = null;
        try {
            String sslKeyStoreType = this.configuration.option(BoltClientOption.CLI_SSL_KEYSTORE_TYPE);
            if (sslKeyStoreType == null) {
                sslKeyStoreType = RpcConfigManager.client_ssl_keystore_type();
            }
            KeyStore ks = KeyStore.getInstance(sslKeyStoreType);
            String sslKeyStore = this.configuration.option(BoltClientOption.CLI_SSL_KEYSTORE);
            if (sslKeyStore == null) {
                sslKeyStore = RpcConfigManager.client_ssl_keystore();
            }
            in = new FileInputStream(sslKeyStore);
            String keyStorePass = this.configuration.option(BoltClientOption.CLI_SSL_KEYSTORE_PASS);
            if (keyStorePass == null) {
                keyStorePass = RpcConfigManager.client_ssl_keystore_pass();
            }
            char[] passChs = keyStorePass.toCharArray();
            ks.load(in, passChs);
            String serverSslAlgorithm = this.configuration.option(BoltServerOption.SRV_SSL_KMF_ALGO);
            if (serverSslAlgorithm == null) {
                serverSslAlgorithm = RpcConfigManager.server_ssl_kmf_algorithm();
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(serverSslAlgorithm);
            kmf.init(ks, passChs);
            String sslAlgorithm = this.configuration.option(BoltClientOption.CLI_SSL_TMF_ALGO);
            if (sslAlgorithm == null) {
                sslAlgorithm = RpcConfigManager.client_ssl_tmf_algorithm();
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(sslAlgorithm);
            tmf.init(ks);
            sslContext = SslContextBuilder.forClient().keyManager(kmf).trustManager(tmf).build();
        }
        catch (Exception e) {
            try {
                logger.error("Fail to init SSL context for connection factory.", (Throwable)e);
                throw new IllegalStateException("Fail to init SSL context", e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(in);
        return sslContext;
    }

    protected Channel doCreateConnection(String targetIP, int targetPort, int connectTimeout) throws Exception {
        String address = targetIP + ":" + targetPort;
        if (logger.isDebugEnabled()) {
            logger.debug("connectTimeout of address [{}] is [{}].", (Object)address, (Object)connectTimeout);
        }
        if (connectTimeout <= 0) {
            throw new IllegalArgumentException(String.format("illegal timeout for creating connection, address: %s, timeout: %d", address, connectTimeout));
        }
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout);
        ChannelFuture future = this.bootstrap.connect((SocketAddress)new InetSocketAddress(targetIP, targetPort));
        future.awaitUninterruptibly();
        if (!future.isDone()) {
            String errMsg = "Create connection to " + address + " timeout!";
            logger.warn(errMsg);
            throw new Exception(errMsg);
        }
        if (future.isCancelled()) {
            String errMsg = "Create connection to " + address + " cancelled by user!";
            logger.warn(errMsg);
            throw new Exception(errMsg);
        }
        if (!future.isSuccess()) {
            String errMsg = "Create connection to " + address + " error!";
            logger.warn(errMsg);
            throw new Exception(errMsg, future.cause());
        }
        return future.channel();
    }
}

