/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.timer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class TimerMetrics
extends ConfigManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final long LOCK_TIMEOUT_MILLIS = 3000L;
    private final transient Lock lock = new ReentrantLock();
    private final ConcurrentMap<String, Metric> timingCount = new ConcurrentHashMap<String, Metric>(1024);
    private final ConcurrentMap<Integer, Metric> timingDistribution = new ConcurrentHashMap<Integer, Metric>(1024);
    public List<Integer> timerDist = new ArrayList<Integer>(){
        {
            this.add(5);
            this.add(60);
            this.add(300);
            this.add(900);
            this.add(3600);
            this.add(14400);
            this.add(28800);
            this.add(86400);
        }
    };
    private final DataVersion dataVersion = new DataVersion();
    private final String configPath;

    public TimerMetrics(String configPath) {
        this.configPath = configPath;
    }

    public long updateDistPair(int period, int value) {
        Metric distPair = this.getDistPair(period);
        return distPair.getCount().addAndGet(value);
    }

    public long addAndGet(MessageExt msg, int value) {
        String topic = msg.getProperty("REAL_TOPIC");
        Metric pair = this.getTopicPair(topic);
        this.getDataVersion().nextVersion();
        pair.setTimeStamp(System.currentTimeMillis());
        return pair.getCount().addAndGet(value);
    }

    public Metric getDistPair(Integer period) {
        Metric pair = (Metric)this.timingDistribution.get(period);
        if (null != pair) {
            return pair;
        }
        pair = new Metric();
        Metric previous = this.timingDistribution.putIfAbsent(period, pair);
        if (null != previous) {
            return previous;
        }
        return pair;
    }

    public Metric getTopicPair(String topic) {
        Metric pair = (Metric)this.timingCount.get(topic);
        if (null != pair) {
            return pair;
        }
        pair = new Metric();
        Metric previous = this.timingCount.putIfAbsent(topic, pair);
        if (null != previous) {
            return previous;
        }
        return pair;
    }

    public List<Integer> getTimerDistList() {
        return this.timerDist;
    }

    public void setTimerDistList(List<Integer> timerDist) {
        this.timerDist = timerDist;
    }

    public long getTimingCount(String topic) {
        Metric pair = (Metric)this.timingCount.get(topic);
        if (null == pair) {
            return 0L;
        }
        return pair.getCount().get();
    }

    public Map<String, Metric> getTimingCount() {
        return this.timingCount;
    }

    protected void write0(Writer writer) {
        TimerMetricsSerializeWrapper wrapper = new TimerMetricsSerializeWrapper();
        wrapper.setTimingCount(this.timingCount);
        wrapper.setDataVersion(this.dataVersion);
        JSON.writeJSONString((Writer)writer, (Object)((Object)wrapper), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible});
    }

    public String encode() {
        return this.encode(false);
    }

    public String configFilePath() {
        return this.configPath;
    }

    public void decode(String jsonString) {
        TimerMetricsSerializeWrapper timerMetricsSerializeWrapper;
        if (jsonString != null && (timerMetricsSerializeWrapper = (TimerMetricsSerializeWrapper)((Object)TimerMetricsSerializeWrapper.fromJson((String)jsonString, TimerMetricsSerializeWrapper.class))) != null) {
            this.timingCount.putAll(timerMetricsSerializeWrapper.getTimingCount());
            this.dataVersion.assignNewOne(timerMetricsSerializeWrapper.getDataVersion());
        }
    }

    public String encode(boolean prettyFormat) {
        TimerMetricsSerializeWrapper metricsSerializeWrapper = new TimerMetricsSerializeWrapper();
        metricsSerializeWrapper.setDataVersion(this.dataVersion);
        metricsSerializeWrapper.setTimingCount(this.timingCount);
        return metricsSerializeWrapper.toJson(prettyFormat);
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public void cleanMetrics(Set<String> topics) {
        if (topics == null || topics.isEmpty()) {
            return;
        }
        Iterator iterator = this.timingCount.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String topic = (String)entry.getKey();
            if (topic.startsWith("rmq_sys_") || topic.startsWith("%LMQ%") || topics.contains(topic)) continue;
            iterator.remove();
            log.info("clean timer metrics, because not in topic config, {}", (Object)topic);
        }
    }

    public boolean removeTimingCount(String topic) {
        try {
            this.timingCount.remove(topic);
        }
        catch (Exception e) {
            log.error("removeTimingCount error", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void persist() {
        String config = this.configFilePath();
        String temp = config + ".tmp";
        String backup = config + ".bak";
        BufferedWriter bufferedWriter = null;
        try {
            File tmpFile = new File(temp);
            File parentDirectory = tmpFile.getParentFile();
            if (!parentDirectory.exists() && !parentDirectory.mkdirs()) {
                log.error("Failed to create directory: {}", (Object)parentDirectory.getCanonicalPath());
                return;
            }
            if (!tmpFile.exists() && !tmpFile.createNewFile()) {
                log.error("Failed to create file: {}", (Object)tmpFile.getCanonicalPath());
                return;
            }
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile, false), StandardCharsets.UTF_8));
            this.write0(bufferedWriter);
            bufferedWriter.flush();
            bufferedWriter.close();
            log.debug("Finished writing tmp file: {}", (Object)temp);
            File configFile = new File(config);
            if (configFile.exists()) {
                Files.copy((File)configFile, (File)new File(backup));
                configFile.delete();
            }
            tmpFile.renameTo(configFile);
            return;
        }
        catch (IOException e) {
            log.error("Failed to persist {}", (Object)temp, (Object)e);
            return;
        }
        finally {
            if (null != bufferedWriter) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class Metric {
        private AtomicLong count = new AtomicLong(0L);
        private long timeStamp = System.currentTimeMillis();

        public AtomicLong getCount() {
            return this.count;
        }

        public void setCount(AtomicLong count) {
            this.count = count;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public String toString() {
            return String.format("[%d,%d]", this.count.get(), this.timeStamp);
        }
    }

    public static class TimerMetricsSerializeWrapper
    extends RemotingSerializable {
        private ConcurrentMap<String, Metric> timingCount = new ConcurrentHashMap<String, Metric>(1024);
        private DataVersion dataVersion = new DataVersion();

        public ConcurrentMap<String, Metric> getTimingCount() {
            return this.timingCount;
        }

        public void setTimingCount(ConcurrentMap<String, Metric> timingCount) {
            this.timingCount = timingCount;
        }

        public DataVersion getDataVersion() {
            return this.dataVersion;
        }

        public void setDataVersion(DataVersion dataVersion) {
            this.dataVersion = dataVersion;
        }
    }
}

