/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.filter.expression;

import org.apache.rocketmq.filter.expression.BinaryExpression;
import org.apache.rocketmq.filter.expression.BooleanExpression;
import org.apache.rocketmq.filter.expression.EvaluationContext;

public abstract class LogicExpression
extends BinaryExpression
implements BooleanExpression {
    public LogicExpression(BooleanExpression left, BooleanExpression right) {
        super(left, right);
    }

    public static BooleanExpression createOR(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new LogicExpression(lvalue, rvalue){

            @Override
            public Object evaluate(EvaluationContext context) throws Exception {
                Boolean lv = (Boolean)this.left.evaluate(context);
                if (lv != null && lv.booleanValue()) {
                    return Boolean.TRUE;
                }
                Boolean rv = (Boolean)this.right.evaluate(context);
                if (rv != null && rv.booleanValue()) {
                    return Boolean.TRUE;
                }
                if (lv == null || rv == null) {
                    return null;
                }
                return Boolean.FALSE;
            }

            @Override
            public String getExpressionSymbol() {
                return "||";
            }
        };
    }

    public static BooleanExpression createAND(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new LogicExpression(lvalue, rvalue){

            @Override
            public Object evaluate(EvaluationContext context) throws Exception {
                Boolean lv = (Boolean)this.left.evaluate(context);
                if (lv != null && !lv.booleanValue()) {
                    return Boolean.FALSE;
                }
                Boolean rv = (Boolean)this.right.evaluate(context);
                if (rv != null && !rv.booleanValue()) {
                    return Boolean.FALSE;
                }
                if (lv == null || rv == null) {
                    return null;
                }
                return Boolean.TRUE;
            }

            @Override
            public String getExpressionSymbol() {
                return "&&";
            }
        };
    }

    @Override
    public abstract Object evaluate(EvaluationContext var1) throws Exception;

    @Override
    public boolean matches(EvaluationContext context) throws Exception {
        Object object = this.evaluate(context);
        return object != null && object == Boolean.TRUE;
    }
}

