/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.FixedSequenceGroup;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.Sequencer;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;

final class ProcessingSequenceBarrier
implements SequenceBarrier {
    private final WaitStrategy waitStrategy;
    private final Sequence dependentSequence;
    private volatile boolean alerted = false;
    private final Sequence cursorSequence;
    private final Sequencer sequencer;

    ProcessingSequenceBarrier(Sequencer sequencer, WaitStrategy waitStrategy, Sequence cursorSequence, Sequence[] dependentSequences) {
        this.sequencer = sequencer;
        this.waitStrategy = waitStrategy;
        this.cursorSequence = cursorSequence;
        this.dependentSequence = 0 == dependentSequences.length ? cursorSequence : new FixedSequenceGroup(dependentSequences);
    }

    @Override
    public long waitFor(long sequence) throws AlertException, InterruptedException, TimeoutException {
        this.checkAlert();
        long availableSequence = this.waitStrategy.waitFor(sequence, this.cursorSequence, this.dependentSequence, this);
        if (availableSequence < sequence) {
            return availableSequence;
        }
        return this.sequencer.getHighestPublishedSequence(sequence, availableSequence);
    }

    @Override
    public long getCursor() {
        return this.dependentSequence.get();
    }

    @Override
    public boolean isAlerted() {
        return this.alerted;
    }

    @Override
    public void alert() {
        this.alerted = true;
        this.waitStrategy.signalAllWhenBlocking();
    }

    @Override
    public void clearAlert() {
        this.alerted = false;
    }

    @Override
    public void checkAlert() throws AlertException {
        if (this.alerted) {
            throw AlertException.INSTANCE;
        }
    }
}

