/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.util;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.rocketmq.common.message.MessageQueue;

public class MessageStoreUtil {
    public static final String TIERED_STORE_LOGGER_NAME = "RocketmqTieredStore";
    public static final String RMQ_SYS_TIERED_STORE_INDEX_TOPIC = "rmq_sys_INDEX";
    public static final long BYTE = 1L;
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final long PB = 0x4000000000000L;
    public static final long EB = 0x1000000000000000L;
    private static final DecimalFormat DEC_FORMAT = new DecimalFormat("#.##");

    private static String formatSize(long size, long divider, String unitName) {
        return DEC_FORMAT.format((double)size / (double)divider) + unitName;
    }

    public static String toHumanReadable(long size) {
        if (size < 0L) {
            return String.valueOf(size);
        }
        if (size >= 0x1000000000000000L) {
            return MessageStoreUtil.formatSize(size, 0x1000000000000000L, "EB");
        }
        if (size >= 0x4000000000000L) {
            return MessageStoreUtil.formatSize(size, 0x4000000000000L, "PB");
        }
        if (size >= 0x10000000000L) {
            return MessageStoreUtil.formatSize(size, 0x10000000000L, "TB");
        }
        if (size >= 0x40000000L) {
            return MessageStoreUtil.formatSize(size, 0x40000000L, "GB");
        }
        if (size >= 0x100000L) {
            return MessageStoreUtil.formatSize(size, 0x100000L, "MB");
        }
        if (size >= 1024L) {
            return MessageStoreUtil.formatSize(size, 1024L, "KB");
        }
        return MessageStoreUtil.formatSize(size, 1L, "B");
    }

    public static String getHash(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            return String.format("%032x", new BigInteger(1, digest)).substring(0, 8);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toFilePath(MessageQueue mq) {
        return String.format("%s/%s/%s", mq.getBrokerName(), mq.getTopic(), mq.getQueueId());
    }

    public static String getIndexFilePath(String brokerName) {
        return MessageStoreUtil.toFilePath(new MessageQueue(RMQ_SYS_TIERED_STORE_INDEX_TOPIC, brokerName, 0));
    }

    public static String offset2FileName(long offset) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(20);
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setGroupingUsed(false);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(Long.toString(offset).getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            String hash = String.format("%032x", new BigInteger(1, digest)).substring(0, 8);
            return hash + numberFormat.format(offset);
        }
        catch (Exception ignore) {
            return numberFormat.format(offset);
        }
    }

    public static long fileName2Offset(String fileName) {
        return Long.parseLong(fileName.substring(fileName.length() - 20));
    }
}

