/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.lmq;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.PullCallback;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.exception.RemotingException;

public class LMQPullConsumer {
    public static final String BROKER_NAME = "broker-a";
    public static final String CONSUMER_GROUP = "CID_LMQ_PULL_1";
    public static final String TOPIC = "TopicLMQParent";
    public static final String LMQ_TOPIC = "%LMQ%123";
    public static final String NAMESRV_ADDR = "127.0.0.1:9876";

    public static void main(String[] args) throws MQClientException, RemotingException, InterruptedException {
        DefaultMQPullConsumer consumer = new DefaultMQPullConsumer(CONSUMER_GROUP);
        consumer.setNamesrvAddr(NAMESRV_ADDR);
        consumer.setRegisterTopics(new HashSet<String>(Arrays.asList(TOPIC)));
        consumer.start();
        consumer.getDefaultMQPullConsumerImpl().getRebalanceImpl().getmQClientFactory().updateTopicRouteInfoFromNameServer(TOPIC);
        MessageQueue lmq = new MessageQueue(LMQ_TOPIC, BROKER_NAME, 0);
        long offset = consumer.minOffset(lmq);
        consumer.pullBlockIfNotFound(lmq, "*", offset, 32, new PullCallback(){

            public void onSuccess(PullResult pullResult) {
                List list = pullResult.getMsgFoundList();
                if (list == null || list.isEmpty()) {
                    return;
                }
                for (MessageExt msg : list) {
                    System.out.printf("%s Pull New Messages: %s %n", Thread.currentThread().getName(), msg);
                }
            }

            public void onException(Throwable e) {
            }
        });
    }
}

