/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.channel;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.proxy.service.channel.InvocationContextInterface;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class InvocationContext
implements InvocationContextInterface {
    private final CompletableFuture<RemotingCommand> response;
    private final long timestamp = System.currentTimeMillis();

    public InvocationContext(CompletableFuture<RemotingCommand> resp) {
        this.response = resp;
    }

    @Override
    public boolean expired(long expiredTimeSec) {
        return System.currentTimeMillis() - this.timestamp >= Duration.ofSeconds(expiredTimeSec).toMillis();
    }

    public CompletableFuture<RemotingCommand> getResponse() {
        return this.response;
    }

    @Override
    public void handle(RemotingCommand remotingCommand) {
        this.response.complete(remotingCommand);
    }
}

