/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.common;

import com.google.common.net.HostAndPort;
import java.util.Objects;
import org.apache.rocketmq.common.utils.IPAddressUtils;

public class Address {
    private AddressScheme addressScheme;
    private HostAndPort hostAndPort;

    public Address(HostAndPort hostAndPort) {
        this.addressScheme = this.buildScheme(hostAndPort);
        this.hostAndPort = hostAndPort;
    }

    public Address(AddressScheme addressScheme, HostAndPort hostAndPort) {
        this.addressScheme = addressScheme;
        this.hostAndPort = hostAndPort;
    }

    public AddressScheme getAddressScheme() {
        return this.addressScheme;
    }

    public void setAddressScheme(AddressScheme addressScheme) {
        this.addressScheme = addressScheme;
    }

    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }

    public void setHostAndPort(HostAndPort hostAndPort) {
        this.hostAndPort = hostAndPort;
    }

    private AddressScheme buildScheme(HostAndPort hostAndPort) {
        if (hostAndPort == null) {
            return AddressScheme.UNRECOGNIZED;
        }
        String address = hostAndPort.getHost();
        if (IPAddressUtils.isValidIPv4((String)address)) {
            return AddressScheme.IPv4;
        }
        if (IPAddressUtils.isValidIPv6((String)address)) {
            return AddressScheme.IPv6;
        }
        return AddressScheme.DOMAIN_NAME;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return this.addressScheme == address.addressScheme && Objects.equals(this.hostAndPort, address.hostAndPort);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addressScheme, this.hostAndPort});
    }

    public static enum AddressScheme {
        IPv4,
        IPv6,
        DOMAIN_NAME,
        UNRECOGNIZED;

    }
}

