/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.snapshot;

import com.alipay.sofa.jraft.storage.SnapshotThrottle;
import com.alipay.sofa.jraft.util.Utils;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ThroughputSnapshotThrottle
implements SnapshotThrottle {
    private final long throttleThroughputBytes;
    private final long checkCycleSecs;
    private long lastThroughputCheckTimeUs;
    private long currThroughputBytes;
    private final Lock lock = new ReentrantLock();
    private final long baseAligningTimeUs;

    public ThroughputSnapshotThrottle(long throttleThroughputBytes, long checkCycleSecs) {
        this.throttleThroughputBytes = throttleThroughputBytes;
        this.checkCycleSecs = checkCycleSecs;
        this.currThroughputBytes = 0L;
        this.baseAligningTimeUs = 1000000L / checkCycleSecs;
        this.lastThroughputCheckTimeUs = this.calculateCheckTimeUs(Utils.monotonicUs());
    }

    private long calculateCheckTimeUs(long currTimeUs) {
        return currTimeUs / this.baseAligningTimeUs * this.baseAligningTimeUs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long throttledByThroughput(long bytes) {
        long availableSize;
        long nowUs = Utils.monotonicUs();
        long limitPerCycle = this.throttleThroughputBytes / this.checkCycleSecs;
        this.lock.lock();
        try {
            if (this.currThroughputBytes + bytes > limitPerCycle) {
                if (nowUs - this.lastThroughputCheckTimeUs <= 1000000L / this.checkCycleSecs) {
                    availableSize = limitPerCycle - this.currThroughputBytes;
                    this.currThroughputBytes = limitPerCycle;
                } else {
                    this.currThroughputBytes = availableSize = bytes > limitPerCycle ? limitPerCycle : bytes;
                    this.lastThroughputCheckTimeUs = this.calculateCheckTimeUs(nowUs);
                }
            } else {
                availableSize = bytes;
                this.currThroughputBytes += availableSize;
            }
        }
        finally {
            this.lock.unlock();
        }
        return availableSize;
    }
}

