/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.closure;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.JRaftUtils;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import com.alipay.sofa.jraft.util.timer.Timeout;
import com.alipay.sofa.jraft.util.timer.Timer;
import com.alipay.sofa.jraft.util.timer.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReadIndexClosure
implements Closure {
    private static final Logger LOG = LoggerFactory.getLogger(ReadIndexClosure.class);
    private static final AtomicIntegerFieldUpdater<ReadIndexClosure> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ReadIndexClosure.class, "state");
    private static final long DEFAULT_TIMEOUT = SystemPropertyUtil.getInt("jraft.read-index.timeout", 2000);
    private static final int PENDING = 0;
    private static final int COMPLETE = 1;
    private static final int TIMEOUT = 2;
    public static final long INVALID_LOG_INDEX = -1L;
    private long index = -1L;
    private byte[] requestContext;
    private volatile int state = 0;

    public ReadIndexClosure() {
        this(DEFAULT_TIMEOUT);
    }

    public ReadIndexClosure(long timeoutMs) {
        if (timeoutMs >= 0L) {
            TimeoutScanner.TIMER.newTimeout(new TimeoutTask(this), timeoutMs, TimeUnit.MILLISECONDS);
        }
    }

    public abstract void run(Status var1, long var2, byte[] var4);

    public void setResult(long index, byte[] reqCtx) {
        this.index = index;
        this.requestContext = reqCtx;
    }

    public long getIndex() {
        return this.index;
    }

    public byte[] getRequestContext() {
        return this.requestContext;
    }

    @Override
    public void run(Status status) {
        if (!STATE_UPDATER.compareAndSet(this, 0, 1)) {
            LOG.warn("A timeout read-index response finally returned: {}.", (Object)status);
            return;
        }
        try {
            this.run(status, this.index, this.requestContext);
        }
        catch (Throwable t) {
            LOG.error("Fail to run ReadIndexClosure with status: {}.", (Object)status, (Object)t);
        }
    }

    static class TimeoutScanner {
        private static final Timer TIMER = JRaftUtils.raftTimerFactory().createTimer("read-index.timeout.scanner");

        TimeoutScanner() {
        }
    }

    static class TimeoutTask
    implements TimerTask {
        private final ReadIndexClosure closure;

        TimeoutTask(ReadIndexClosure closure) {
            this.closure = closure;
        }

        @Override
        public void run(Timeout timeout) throws Exception {
            if (!STATE_UPDATER.compareAndSet(this.closure, 0, 2)) {
                return;
            }
            Status status = new Status(RaftError.ETIMEDOUT, "read-index request timeout", new Object[0]);
            try {
                this.closure.run(status, -1L, null);
            }
            catch (Throwable t) {
                LOG.error("[Timeout] fail to run ReadIndexClosure with status: {}.", (Object)status, (Object)t);
            }
        }
    }
}

