/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.lock;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ReadWriteCASLock {
    private final AtomicBoolean writeLock = new AtomicBoolean(true);
    private final AtomicInteger readLock = new AtomicInteger(0);

    public void acquireWriteLock() {
        boolean isLock = false;
        while (!(isLock = this.writeLock.compareAndSet(true, false))) {
        }
        while (!(isLock = this.readLock.get() == 0)) {
        }
    }

    public void releaseWriteLock() {
        this.writeLock.compareAndSet(false, true);
    }

    public void acquireReadLock() {
        boolean isLock = false;
        while (!(isLock = this.writeLock.get())) {
        }
        this.readLock.getAndIncrement();
    }

    public void releaseReadLock() {
        this.readLock.getAndDecrement();
    }

    public boolean getWriteLock() {
        return this.writeLock.get() && this.readLock.get() == 0;
    }

    public boolean getReadLock() {
        return this.writeLock.get();
    }
}

