/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.pop.PopCheckPoint;

public class PopInflightMessageCounter {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final String TOPIC_GROUP_SEPARATOR = "@";
    private final Map<String, Map<Integer, AtomicLong>> topicInFlightMessageNum = new ConcurrentHashMap<String, Map<Integer, AtomicLong>>(512);
    private final BrokerController brokerController;

    public PopInflightMessageCounter(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public void incrementInFlightMessageNum(String topic, String group, int queueId, int num) {
        if (num <= 0) {
            return;
        }
        this.topicInFlightMessageNum.compute(PopInflightMessageCounter.buildKey(topic, group), (key, queueNum) -> {
            if (queueNum == null) {
                queueNum = new ConcurrentHashMap<Integer, AtomicLong>(8);
            }
            queueNum.compute(queueId, (queueIdKey, counter) -> {
                if (counter == null) {
                    return new AtomicLong(num);
                }
                if (counter.addAndGet(num) <= 0L) {
                    return null;
                }
                return counter;
            });
            return queueNum;
        });
    }

    public void decrementInFlightMessageNum(String topic, String group, long popTime, int qId, int delta) {
        if (popTime < this.brokerController.getShouldStartTime()) {
            return;
        }
        this.decrementInFlightMessageNum(topic, group, qId, delta);
    }

    public void decrementInFlightMessageNum(PopCheckPoint checkPoint) {
        if (checkPoint.getPopTime() < this.brokerController.getShouldStartTime()) {
            return;
        }
        this.decrementInFlightMessageNum(checkPoint.getTopic(), checkPoint.getCId(), checkPoint.getQueueId(), 1);
    }

    private void decrementInFlightMessageNum(String topic, String group, int queueId, int delta) {
        this.topicInFlightMessageNum.computeIfPresent(PopInflightMessageCounter.buildKey(topic, group), (key, queueNum) -> {
            queueNum.computeIfPresent(queueId, (queueIdKey, counter) -> {
                if (counter.addAndGet(-delta) <= 0L) {
                    return null;
                }
                return counter;
            });
            if (queueNum.isEmpty()) {
                return null;
            }
            return queueNum;
        });
    }

    public void clearInFlightMessageNumByGroupName(String group) {
        Set<String> topicGroupKey = this.topicInFlightMessageNum.keySet();
        for (String key : topicGroupKey) {
            Pair<String, String> topicAndGroup;
            if (!key.contains(group) || (topicAndGroup = PopInflightMessageCounter.splitKey(key)) == null || !((String)topicAndGroup.getObject2()).equals(group)) continue;
            this.topicInFlightMessageNum.remove(key);
            log.info("PopInflightMessageCounter#clearInFlightMessageNumByGroupName: clean by group, topic={}, group={}", topicAndGroup.getObject1(), topicAndGroup.getObject2());
        }
    }

    public void clearInFlightMessageNumByTopicName(String topic) {
        Set<String> topicGroupKey = this.topicInFlightMessageNum.keySet();
        for (String key : topicGroupKey) {
            Pair<String, String> topicAndGroup;
            if (!key.contains(topic) || (topicAndGroup = PopInflightMessageCounter.splitKey(key)) == null || !((String)topicAndGroup.getObject1()).equals(topic)) continue;
            this.topicInFlightMessageNum.remove(key);
            log.info("PopInflightMessageCounter#clearInFlightMessageNumByTopicName: clean by topic, topic={}, group={}", topicAndGroup.getObject1(), topicAndGroup.getObject2());
        }
    }

    public void clearInFlightMessageNum(String topic, String group, int queueId) {
        this.topicInFlightMessageNum.computeIfPresent(PopInflightMessageCounter.buildKey(topic, group), (key, queueNum) -> {
            queueNum.computeIfPresent(queueId, (queueIdKey, counter) -> null);
            if (queueNum.isEmpty()) {
                return null;
            }
            return queueNum;
        });
    }

    public long getGroupPopInFlightMessageNum(String topic, String group, int queueId) {
        Map<Integer, AtomicLong> queueCounter = this.topicInFlightMessageNum.get(PopInflightMessageCounter.buildKey(topic, group));
        if (queueCounter == null) {
            return 0L;
        }
        AtomicLong counter = queueCounter.get(queueId);
        if (counter == null) {
            return 0L;
        }
        return Math.max(0L, counter.get());
    }

    private static Pair<String, String> splitKey(String key) {
        String[] strings = key.split(TOPIC_GROUP_SEPARATOR);
        if (strings.length != 2) {
            return null;
        }
        return new Pair((Object)strings[0], (Object)strings[1]);
    }

    private static String buildKey(String topic, String group) {
        return topic + TOPIC_GROUP_SEPARATOR + group;
    }
}

