/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.namesrv.processor;

import com.alibaba.fastjson.serializer.SerializerFeature;
import io.netty.channel.ChannelHandlerContext;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.namesrv.NamesrvController;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.namesrv.GetRouteInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;

public class ClientRequestProcessor
implements NettyRequestProcessor {
    private static Logger log = LoggerFactory.getLogger((String)"RocketmqNamesrv");
    protected NamesrvController namesrvController;
    private long startupTimeMillis;

    public ClientRequestProcessor(NamesrvController namesrvController) {
        this.namesrvController = namesrvController;
        this.startupTimeMillis = System.currentTimeMillis();
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        return this.getRouteInfoByTopic(ctx, request);
    }

    public RemotingCommand getRouteInfoByTopic(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        boolean namesrvReady;
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetRouteInfoRequestHeader requestHeader = (GetRouteInfoRequestHeader)request.decodeCommandCustomHeader(GetRouteInfoRequestHeader.class);
        boolean bl = namesrvReady = System.currentTimeMillis() - this.startupTimeMillis >= TimeUnit.SECONDS.toMillis(this.namesrvController.getNamesrvConfig().getWaitSecondsForService());
        if (this.namesrvController.getNamesrvConfig().isNeedWaitForService() && !namesrvReady) {
            log.warn("name server not ready. request code {} ", (Object)request.getCode());
            response.setCode(1);
            response.setRemark("name server not ready");
            return response;
        }
        TopicRouteData topicRouteData = this.namesrvController.getRouteInfoManager().pickupTopicRouteData(requestHeader.getTopic());
        if (topicRouteData != null) {
            if (this.namesrvController.getNamesrvConfig().isOrderMessageEnable()) {
                String orderTopicConf = this.namesrvController.getKvConfigManager().getKVConfig("ORDER_TOPIC_CONFIG", requestHeader.getTopic());
                topicRouteData.setOrderTopicConf(orderTopicConf);
            }
            Boolean standardJsonOnly = Optional.ofNullable(requestHeader.getAcceptStandardJsonOnly()).orElse(false);
            byte[] content = request.getVersion() >= MQVersion.Version.V4_9_4.ordinal() || standardJsonOnly != false ? topicRouteData.encode(new SerializerFeature[]{SerializerFeature.BrowserCompatible, SerializerFeature.QuoteFieldNames, SerializerFeature.SkipTransientField, SerializerFeature.MapSortField}) : topicRouteData.encode();
            response.setBody(content);
            response.setCode(0);
            response.setRemark(null);
            return response;
        }
        response.setCode(17);
        response.setRemark("No topic route info in name server for the topic: " + requestHeader.getTopic() + FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ"));
        return response;
    }

    public boolean rejectRequest() {
        return false;
    }
}

