/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh.command;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.shell.cli.CliUtils;
import org.apache.ratis.shell.cli.sh.command.AbstractCommand;
import org.apache.ratis.shell.cli.sh.command.Context;
import org.apache.ratis.util.ProtoUtils;

public abstract class AbstractRatisCommand
extends AbstractCommand {
    public static final String PEER_OPTION_NAME = "peers";
    public static final String GROUPID_OPTION_NAME = "groupid";
    private RaftGroup raftGroup;
    private GroupInfoReply groupInfoReply;

    protected AbstractRatisCommand(Context context) {
        super(context);
    }

    @Override
    public int run(CommandLine cl) throws IOException {
        List<RaftPeer> peers = CliUtils.parseRaftPeers(cl.getOptionValue(PEER_OPTION_NAME));
        RaftGroupId groupIdSpecified = CliUtils.parseRaftGroupId(cl.getOptionValue(GROUPID_OPTION_NAME));
        this.raftGroup = RaftGroup.valueOf((RaftGroupId)(groupIdSpecified != null ? groupIdSpecified : RaftGroupId.randomId()), peers);
        PrintStream printStream = this.getPrintStream();
        try (RaftClient client = this.newRaftClient();){
            RaftGroupId remoteGroupId = CliUtils.getGroupId(client, peers, groupIdSpecified, printStream);
            this.groupInfoReply = CliUtils.getGroupInfo(client, peers, remoteGroupId, printStream);
            this.raftGroup = this.groupInfoReply.getGroup();
        }
        return 0;
    }

    protected RaftClient newRaftClient() {
        return this.getContext().newRaftClient(this.getRaftGroup());
    }

    @Override
    public Options getOptions() {
        return new Options().addOption(Option.builder().option(PEER_OPTION_NAME).hasArg().required().desc("Peer addresses seperated by comma").build()).addOption(GROUPID_OPTION_NAME, true, "Raft group id");
    }

    protected RaftGroup getRaftGroup() {
        return this.raftGroup;
    }

    protected GroupInfoReply getGroupInfoReply() {
        return this.groupInfoReply;
    }

    protected RaftProtos.RaftPeerProto getLeader(RaftProtos.RoleInfoProto roleInfo) {
        if (roleInfo == null) {
            return null;
        }
        if (roleInfo.getRole() == RaftProtos.RaftPeerRole.LEADER) {
            return roleInfo.getSelf();
        }
        RaftProtos.FollowerInfoProto followerInfo = roleInfo.getFollowerInfo();
        if (followerInfo == null) {
            return null;
        }
        return followerInfo.getLeaderInfo().getId();
    }

    protected void processReply(RaftClientReply reply, Supplier<String> messageSupplier) throws IOException {
        CliUtils.checkReply(reply, messageSupplier, this.getPrintStream());
    }

    protected List<RaftPeerId> getIds(String[] optionValues, BiConsumer<RaftPeerId, InetSocketAddress> consumer) {
        if (optionValues == null) {
            return Collections.emptyList();
        }
        ArrayList<RaftPeerId> ids = new ArrayList<RaftPeerId>();
        for (String address : optionValues) {
            InetSocketAddress serverAddress = CliUtils.parseInetSocketAddress(address);
            RaftPeerId peerId = CliUtils.getPeerId(serverAddress);
            consumer.accept(peerId, serverAddress);
            ids.add(peerId);
        }
        return ids;
    }

    protected Stream<RaftPeer> getPeerStream(RaftProtos.RaftPeerRole role) {
        RaftProtos.RaftConfigurationProto conf = this.groupInfoReply.getConf().orElse(null);
        if (conf == null) {
            return role == RaftProtos.RaftPeerRole.FOLLOWER ? this.getRaftGroup().getPeers().stream() : Stream.empty();
        }
        Set targets = (role == RaftProtos.RaftPeerRole.LISTENER ? conf.getListenersList() : conf.getPeersList()).stream().map(ProtoUtils::toRaftPeer).collect(Collectors.toSet());
        return this.getRaftGroup().getPeers().stream().filter(targets::contains);
    }
}

