/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.ratis.client.api.SnapshotManagementApi;
import org.apache.ratis.client.impl.RaftClientImpl;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.rpc.CallId;

class SnapshotManagementImpl
implements SnapshotManagementApi {
    private final RaftClientImpl client;
    private final RaftPeerId server;

    SnapshotManagementImpl(RaftPeerId server, RaftClientImpl client) {
        this.server = server;
        this.client = Objects.requireNonNull(client, "client == null");
    }

    @Override
    public RaftClientReply create(long creationGap, long timeoutMs) throws IOException {
        long callId = CallId.getAndIncrement();
        return this.client.io().sendRequestWithRetry(() -> SnapshotManagementRequest.newCreate(this.client.getId(), Optional.ofNullable(this.server).orElseGet(this.client::getLeaderId), this.client.getGroupId(), callId, timeoutMs, creationGap));
    }
}

