/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.DiskEncryptionSettings;
import com.microsoft.azure.management.compute.DiskVolumeEncryptionMonitor;
import com.microsoft.azure.management.compute.EncryptionStatus;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class WindowsVolumeEncryptionMonitorImpl
implements DiskVolumeEncryptionMonitor {
    private final String rgName;
    private final String vmName;
    private final ComputeManager computeManager;
    private VirtualMachineExtensionInner encryptionExtension;
    private VirtualMachineInner virtualMachine;

    WindowsVolumeEncryptionMonitorImpl(String virtualMachineId, ComputeManager computeManager) {
        this.rgName = ResourceUtils.groupFromResourceId((String)virtualMachineId);
        this.vmName = ResourceUtils.nameFromResourceId((String)virtualMachineId);
        this.computeManager = computeManager;
    }

    @Override
    public OperatingSystemTypes osType() {
        return OperatingSystemTypes.WINDOWS;
    }

    @Override
    public String progressMessage() {
        if (!this.hasEncryptionDetails()) {
            return null;
        }
        return String.format("OSDisk: %s DataDisk: %s", new Object[]{this.osDiskStatus(), this.dataDiskStatus()});
    }

    @Override
    public EncryptionStatus osDiskStatus() {
        if (!this.hasEncryptionDetails()) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        if (this.encryptionExtension.provisioningState() == null) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        if (!this.encryptionExtension.provisioningState().equalsIgnoreCase("Succeeded")) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        if (this.virtualMachine.storageProfile() == null || this.virtualMachine.storageProfile().osDisk() == null || this.virtualMachine.storageProfile().osDisk().encryptionSettings() == null) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        DiskEncryptionSettings encryptionSettings = this.virtualMachine.storageProfile().osDisk().encryptionSettings();
        if (encryptionSettings.diskEncryptionKey() != null && encryptionSettings.diskEncryptionKey().secretUrl() != null && Utils.toPrimitiveBoolean((Boolean)encryptionSettings.enabled())) {
            return EncryptionStatus.ENCRYPTED;
        }
        return EncryptionStatus.NOT_ENCRYPTED;
    }

    @Override
    public EncryptionStatus dataDiskStatus() {
        if (!this.hasEncryptionDetails()) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        if (this.encryptionExtension.provisioningState() == null) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        if (!this.encryptionExtension.provisioningState().equalsIgnoreCase("Succeeded")) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        LinkedHashMap publicSettings = new LinkedHashMap();
        if (this.encryptionExtension.settings() != null) {
            publicSettings = (LinkedHashMap)this.encryptionExtension.settings();
        }
        if (!publicSettings.containsKey("VolumeType") || ((HashMap)publicSettings).get("VolumeType") == null || ((String)((HashMap)publicSettings).get("VolumeType")).isEmpty() || ((String)((HashMap)publicSettings).get("VolumeType")).equalsIgnoreCase("All") || ((String)((HashMap)publicSettings).get("VolumeType")).equalsIgnoreCase("Data")) {
            String encryptionOperation = (String)((HashMap)publicSettings).get("EncryptionOperation");
            if (encryptionOperation != null && encryptionOperation.equalsIgnoreCase("EnableEncryption")) {
                return EncryptionStatus.ENCRYPTED;
            }
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        return EncryptionStatus.UNKNOWN;
    }

    public DiskVolumeEncryptionMonitor refresh() {
        return (DiskVolumeEncryptionMonitor)this.refreshAsync().toBlocking().last();
    }

    @Override
    public Observable<DiskVolumeEncryptionMonitor> refreshAsync() {
        final WindowsVolumeEncryptionMonitorImpl self = this;
        return this.retrieveVirtualMachineAsync().flatMap((Func1)new Func1<VirtualMachineInner, Observable<DiskVolumeEncryptionMonitor>>(){

            public Observable<DiskVolumeEncryptionMonitor> call(VirtualMachineInner virtualMachine) {
                self.virtualMachine = virtualMachine;
                if (virtualMachine.resources() != null) {
                    for (VirtualMachineExtensionInner extension : virtualMachine.resources()) {
                        if (!extension.publisher().equalsIgnoreCase("Microsoft.Azure.Security") || !extension.virtualMachineExtensionType().equalsIgnoreCase("AzureDiskEncryption")) continue;
                        self.encryptionExtension = extension;
                        break;
                    }
                }
                return Observable.just((Object)self);
            }
        });
    }

    private Observable<VirtualMachineInner> retrieveVirtualMachineAsync() {
        return ((ComputeManagementClientImpl)((Object)this.computeManager.inner())).virtualMachines().getByResourceGroupAsync(this.rgName, this.vmName).flatMap((Func1)new Func1<VirtualMachineInner, Observable<VirtualMachineInner>>(){

            public Observable<VirtualMachineInner> call(VirtualMachineInner virtualMachine) {
                if (virtualMachine == null) {
                    return Observable.error((Throwable)new Exception(String.format("VM with name '%s' not found (resource group '%s')", WindowsVolumeEncryptionMonitorImpl.this.vmName, WindowsVolumeEncryptionMonitorImpl.this.rgName)));
                }
                return Observable.just((Object)((Object)virtualMachine));
            }
        });
    }

    private boolean hasEncryptionDetails() {
        return this.virtualMachine != null && this.encryptionExtension != null;
    }
}

