/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.ServerKeyInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ServerKeysInner {
    private ServerKeysService service;
    private SqlManagementClientImpl client;

    public ServerKeysInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ServerKeysService)retrofit.create(ServerKeysService.class);
        this.client = client;
    }

    public PagedList<ServerKeyInner> listByServer(String resourceGroupName, String serverName) {
        ServiceResponse response = (ServiceResponse)this.listByServerSinglePageAsync(resourceGroupName, serverName).toBlocking().single();
        return new PagedList<ServerKeyInner>((Page)response.body()){

            public Page<ServerKeyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ServerKeysInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ServerKeyInner>> listByServerAsync(String resourceGroupName, String serverName, ListOperationCallback<ServerKeyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerSinglePageAsync(resourceGroupName, serverName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ServerKeyInner>>>>(){

            public Observable<ServiceResponse<Page<ServerKeyInner>>> call(String nextPageLink) {
                return ServerKeysInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ServerKeyInner>> listByServerAsync(String resourceGroupName, String serverName) {
        return this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<Page<ServerKeyInner>>, Page<ServerKeyInner>>(){

            public Page<ServerKeyInner> call(ServiceResponse<Page<ServerKeyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ServerKeyInner>>> listByServerWithServiceResponseAsync(String resourceGroupName, String serverName) {
        return this.listByServerSinglePageAsync(resourceGroupName, serverName).concatMap((Func1)new Func1<ServiceResponse<Page<ServerKeyInner>>, Observable<ServiceResponse<Page<ServerKeyInner>>>>(){

            public Observable<ServiceResponse<Page<ServerKeyInner>>> call(ServiceResponse<Page<ServerKeyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ServerKeysInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ServerKeyInner>>> listByServerSinglePageAsync(String resourceGroupName, String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.listByServer(resourceGroupName, serverName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServerKeyInner>>>>(){

            public Observable<ServiceResponse<Page<ServerKeyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServerKeysInner.this.listByServerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ServerKeyInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ServerKeyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServerKeyInner get(String resourceGroupName, String serverName, String keyName) {
        return (ServerKeyInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, keyName).toBlocking().single()).body();
    }

    public ServiceFuture<ServerKeyInner> getAsync(String resourceGroupName, String serverName, String keyName, ServiceCallback<ServerKeyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, keyName), serviceCallback);
    }

    public Observable<ServerKeyInner> getAsync(String resourceGroupName, String serverName, String keyName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, keyName).map((Func1)new Func1<ServiceResponse<ServerKeyInner>, ServerKeyInner>(){

            public ServerKeyInner call(ServiceResponse<ServerKeyInner> response) {
                return (ServerKeyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ServerKeyInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String keyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.get(resourceGroupName, serverName, keyName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerKeyInner>>>(){

            public Observable<ServiceResponse<ServerKeyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerKeysInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerKeyInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerKeyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServerKeyInner createOrUpdate(String resourceGroupName, String serverName, String keyName, ServerKeyInner parameters) {
        return (ServerKeyInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, keyName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<ServerKeyInner> createOrUpdateAsync(String resourceGroupName, String serverName, String keyName, ServerKeyInner parameters, ServiceCallback<ServerKeyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, keyName, parameters), serviceCallback);
    }

    public Observable<ServerKeyInner> createOrUpdateAsync(String resourceGroupName, String serverName, String keyName, ServerKeyInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, keyName, parameters).map((Func1)new Func1<ServiceResponse<ServerKeyInner>, ServerKeyInner>(){

            public ServerKeyInner call(ServiceResponse<ServerKeyInner> response) {
                return (ServerKeyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ServerKeyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String keyName, ServerKeyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serverName, keyName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ServerKeyInner>(){}.getType());
    }

    public ServerKeyInner beginCreateOrUpdate(String resourceGroupName, String serverName, String keyName, ServerKeyInner parameters) {
        return (ServerKeyInner)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, keyName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ServerKeyInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String keyName, ServerKeyInner parameters, ServiceCallback<ServerKeyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, keyName, parameters), serviceCallback);
    }

    public Observable<ServerKeyInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String keyName, ServerKeyInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, keyName, parameters).map((Func1)new Func1<ServiceResponse<ServerKeyInner>, ServerKeyInner>(){

            public ServerKeyInner call(ServiceResponse<ServerKeyInner> response) {
                return (ServerKeyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ServerKeyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String keyName, ServerKeyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2015-05-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, serverName, keyName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerKeyInner>>>(){

            public Observable<ServiceResponse<ServerKeyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerKeysInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerKeyInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerKeyInner>(){}.getType()).register(201, new TypeToken<ServerKeyInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String keyName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, keyName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String keyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, keyName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String keyName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, keyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String keyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, serverName, keyName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String serverName, String keyName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, keyName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String serverName, String keyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, keyName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String serverName, String keyName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, keyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serverName, String keyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.beginDelete(resourceGroupName, serverName, keyName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerKeysInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ServerKeyInner> listByServerNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ServerKeyInner>((Page)response.body()){

            public Page<ServerKeyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ServerKeysInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ServerKeyInner>> listByServerNextAsync(String nextPageLink, ServiceFuture<List<ServerKeyInner>> serviceFuture, ListOperationCallback<ServerKeyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ServerKeyInner>>>>(){

            public Observable<ServiceResponse<Page<ServerKeyInner>>> call(String nextPageLink) {
                return ServerKeysInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ServerKeyInner>> listByServerNextAsync(String nextPageLink) {
        return this.listByServerNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ServerKeyInner>>, Page<ServerKeyInner>>(){

            public Page<ServerKeyInner> call(ServiceResponse<Page<ServerKeyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ServerKeyInner>>> listByServerNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByServerNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ServerKeyInner>>, Observable<ServiceResponse<Page<ServerKeyInner>>>>(){

            public Observable<ServiceResponse<Page<ServerKeyInner>>> call(ServiceResponse<Page<ServerKeyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ServerKeysInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ServerKeyInner>>> listByServerNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByServerNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServerKeyInner>>>>(){

            public Observable<ServiceResponse<Page<ServerKeyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServerKeysInner.this.listByServerNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ServerKeyInner>> listByServerNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ServerKeyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ServerKeysService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerKeys listByServer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/keys")
        public Observable<Response<ResponseBody>> listByServer(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerKeys get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/keys/{keyName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="keyName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerKeys createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/keys/{keyName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="keyName") String var3, @Path(value="subscriptionId") String var4, @Body ServerKeyInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerKeys beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/keys/{keyName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="keyName") String var3, @Path(value="subscriptionId") String var4, @Body ServerKeyInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerKeys delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/keys/{keyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="keyName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerKeys beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/keys/{keyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="keyName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerKeys listByServerNext"})
        @GET
        public Observable<Response<ResponseBody>> listByServerNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

