/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batchai.BatchAIExperiment;
import com.microsoft.azure.management.batchai.BatchAIExperiments;
import com.microsoft.azure.management.batchai.BatchAIWorkspace;
import com.microsoft.azure.management.batchai.implementation.BatchAIExperimentImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManager;
import com.microsoft.azure.management.batchai.implementation.BatchAIWorkspaceImpl;
import com.microsoft.azure.management.batchai.implementation.ExperimentInner;
import com.microsoft.azure.management.batchai.implementation.ExperimentsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class BatchAIExperimentsImpl
extends CreatableResourcesImpl<BatchAIExperiment, BatchAIExperimentImpl, ExperimentInner>
implements BatchAIExperiments {
    private final BatchAIWorkspaceImpl workspace;

    BatchAIExperimentsImpl(BatchAIWorkspaceImpl workspace) {
        this.workspace = workspace;
    }

    public BatchAIExperimentImpl define(String name) {
        return this.wrapModel(name);
    }

    protected BatchAIExperimentImpl wrapModel(String name) {
        ExperimentInner inner = new ExperimentInner();
        return new BatchAIExperimentImpl(name, this.workspace, inner);
    }

    protected BatchAIExperimentImpl wrapModel(ExperimentInner inner) {
        if (inner == null) {
            return null;
        }
        return new BatchAIExperimentImpl(inner.name(), this.workspace, inner);
    }

    public PagedList<BatchAIExperiment> list() {
        return this.wrapList(this.inner().listByWorkspace(this.workspace.resourceGroupName(), this.workspace.name()));
    }

    public Observable<BatchAIExperiment> listAsync() {
        return this.wrapPageAsync(this.inner().listByWorkspaceAsync(this.workspace.resourceGroupName(), this.workspace.name()));
    }

    public BatchAIWorkspace parent() {
        return this.workspace;
    }

    public BatchAIExperimentImpl getById(String id) {
        return (BatchAIExperimentImpl)this.getByIdAsync(id).toBlocking().single();
    }

    public Observable<BatchAIExperiment> getByIdAsync(String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.inner().getAsync(resourceId.resourceGroupName(), this.workspace.name(), resourceId.name()).map((Func1)new Func1<ExperimentInner, BatchAIExperiment>(){

            public BatchAIExperiment call(ExperimentInner innerT) {
                return BatchAIExperimentsImpl.this.wrapModel(innerT);
            }
        });
    }

    public ServiceFuture<BatchAIExperiment> getByIdAsync(String id, ServiceCallback<BatchAIExperiment> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    public BatchAIManager manager() {
        return (BatchAIManager)this.workspace.manager();
    }

    public Completable deleteByIdAsync(String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.inner().deleteAsync(resourceId.resourceGroupName(), this.workspace.name(), resourceId.name()).toCompletable();
    }

    public ExperimentsInner inner() {
        return ((BatchAIManagementClientImpl)((Object)this.manager().inner())).experiments();
    }

    public Observable<BatchAIExperiment> getByNameAsync(String name) {
        return this.inner().getAsync(this.workspace.resourceGroupName(), this.workspace.name(), name).map((Func1)new Func1<ExperimentInner, BatchAIExperiment>(){

            public BatchAIExperiment call(ExperimentInner innerT) {
                return BatchAIExperimentsImpl.this.wrapModel(innerT);
            }
        });
    }

    public BatchAIExperimentImpl getByName(String name) {
        return (BatchAIExperimentImpl)this.getByNameAsync(name).toBlocking().single();
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).await();
    }

    public ServiceFuture<Void> deleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return ServiceFuture.fromResponse(this.inner().deleteWithServiceResponseAsync(this.workspace.resourceGroupName(), this.workspace.name(), name), callback);
    }

    public Completable deleteByNameAsync(String name) {
        return this.inner().deleteAsync(this.workspace.resourceGroupName(), this.workspace.name(), name).toCompletable();
    }
}

