/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.batchai.AllocationState;
import com.microsoft.azure.management.batchai.BatchAIError;
import com.microsoft.azure.management.batchai.BatchAIWorkspace;
import com.microsoft.azure.management.batchai.DeallocationOption;
import com.microsoft.azure.management.batchai.NodeSetup;
import com.microsoft.azure.management.batchai.NodeSetupTask;
import com.microsoft.azure.management.batchai.NodeStateCounts;
import com.microsoft.azure.management.batchai.ProvisioningState;
import com.microsoft.azure.management.batchai.RemoteLoginInformation;
import com.microsoft.azure.management.batchai.ResourceId;
import com.microsoft.azure.management.batchai.ScaleSettings;
import com.microsoft.azure.management.batchai.VirtualMachineConfiguration;
import com.microsoft.azure.management.batchai.VmPriority;
import com.microsoft.azure.management.batchai.implementation.BatchAIManager;
import com.microsoft.azure.management.batchai.implementation.ClusterInner;
import com.microsoft.azure.management.batchai.model.HasMountVolumes;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasName;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.List;
import org.joda.time.DateTime;
import rx.Observable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_6_0)
public interface BatchAICluster
extends HasInner<ClusterInner>,
Indexable,
HasId,
HasName,
HasManager<BatchAIManager>,
Refreshable<BatchAICluster>,
Updatable<Update> {
    @Method
    public PagedList<RemoteLoginInformation> listRemoteLoginInformation();

    @Method
    public Observable<RemoteLoginInformation> listRemoteLoginInformationAsync();

    public String vmSize();

    public VmPriority vmPriority();

    public ScaleSettings scaleSettings();

    public VirtualMachineConfiguration virtualMachineConfiguration();

    public NodeSetup nodeSetup();

    public String adminUserName();

    public ResourceId subnet();

    public DateTime creationTime();

    public ProvisioningState provisioningState();

    public DateTime provisioningStateTransitionTime();

    public AllocationState allocationState();

    public DateTime allocationStateTransitionTime();

    public List<BatchAIError> errors();

    public int currentNodeCount();

    public NodeStateCounts nodeStateCounts();

    public BatchAIWorkspace workspace();

    public static interface Update
    extends Appliable<BatchAICluster>,
    UpdateStages.WithScaleSettings {
    }

    public static interface UpdateStages {

        public static interface WithScaleSettings {
            public Update withAutoScale(int var1, int var2);

            public Update withAutoScale(int var1, int var2, int var3);

            public Update withManualScale(int var1);

            public Update withManualScale(int var1, DeallocationOption var2);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<BatchAICluster>,
        WithUserCredentials,
        WithVMPriority,
        WithSetupTask,
        HasMountVolumes.DefinitionStages.WithMountVolumes<WithCreate>,
        WithAppInsightsResourceId,
        WithVirtualMachineImage,
        WithSubnet {
        }

        @Beta(value=Beta.SinceVersion.V1_8_0)
        public static interface WithVirtualMachineImage {
            public WithCreate withVirtualMachineImage(String var1, String var2, String var3, String var4);

            public WithCreate withVirtualMachineImage(String var1, String var2, String var3);

            public WithCreate withVirtualMachineImageId(String var1, String var2, String var3, String var4);
        }

        @Beta(value=Beta.SinceVersion.V1_8_0)
        public static interface WithSubnet {
            public WithCreate withSubnet(String var1);

            public WithCreate withSubnet(String var1, String var2);
        }

        @Beta(value=Beta.SinceVersion.V1_8_0)
        public static interface WithAppInsightsKey {
            public WithCreate withInstrumentationKey(String var1);

            public WithCreate withInstrumentationKeySecretReference(String var1, String var2);
        }

        @Beta(value=Beta.SinceVersion.V1_8_0)
        public static interface WithAppInsightsResourceId {
            public WithAppInsightsKey withAppInsightsComponentId(String var1);
        }

        public static interface WithSetupTask {
            @Method
            public NodeSetupTask.DefinitionStages.Blank<WithCreate> defineSetupTask();
        }

        public static interface WithVMPriority {
            public WithCreate withLowPriority();
        }

        public static interface WithScaleSettings {
            public WithCreate withAutoScale(int var1, int var2);

            public WithCreate withAutoScale(int var1, int var2, int var3);

            public WithCreate withManualScale(int var1);

            public WithCreate withManualScale(int var1, DeallocationOption var2);
        }

        public static interface WithUserCredentials {
            public WithScaleSettings withPassword(String var1);

            public WithScaleSettings withSshPublicKey(String var1);
        }

        public static interface WithUserName {
            public WithUserCredentials withUserName(String var1);
        }

        public static interface WithVMSize {
            public WithUserName withVMSize(String var1);
        }

        public static interface Blank
        extends WithVMSize {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithUserName,
    DefinitionStages.WithUserCredentials,
    DefinitionStages.WithScaleSettings,
    DefinitionStages.WithAppInsightsKey,
    DefinitionStages.WithCreate {
    }
}

