/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.BoundSet;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding18;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintExceptionFormula;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintExpressionFormula;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintFormula;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintTypeFormula;
import org.eclipse.jdt.internal.compiler.lookup.InferenceFailureException;
import org.eclipse.jdt.internal.compiler.lookup.InferenceSubstitution;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionCastTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBound;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.util.Sorting;

public class InferenceContext18 {
    static final boolean SIMULATE_BUG_JDK_8026527 = true;
    static final boolean ARGUMENT_CONSTRAINTS_ARE_SOFT = false;
    InvocationSite currentInvocation;
    Expression[] invocationArguments;
    InferenceVariable[] inferenceVariables;
    int variableCount = 0;
    ConstraintFormula[] initialConstraints;
    BoundSet currentBounds;
    BoundSet storedSolution;
    Map<TypeBinding, Solution> solutionsPerTargetType = new HashMap<TypeBinding, Solution>();
    int inferenceKind;
    public int stepCompleted = 0;
    public static final int NOT_INFERRED = 0;
    public static final int APPLICABILITY_INFERRED = 1;
    public static final int TYPE_INFERRED = 2;
    public static final int BINDINGS_UPDATED = 3;
    public List<ConstraintFormula> constraintsWithUncheckedConversion;
    List<InvocationSite> innerPolies = new ArrayList<InvocationSite>();
    public InferenceContext18 outerContext;
    private ArrayList<MethodBinding> problemMethods;
    Scope scope;
    LookupEnvironment environment;
    ReferenceBinding object;
    public static final int CHECK_STRICT = 1;
    public static final int CHECK_LOOSE = 2;
    public static final int CHECK_VARARG = 3;
    int captureId = 0;

    public InferenceContext18(Scope scope, Expression[] arguments, InvocationSite site) {
        this.scope = scope;
        this.environment = scope.environment();
        this.object = scope.getJavaLangObject();
        this.invocationArguments = arguments;
        this.currentInvocation = site;
    }

    public InferenceContext18(Scope scope) {
        this.scope = scope;
        this.environment = scope.environment();
        this.object = scope.getJavaLangObject();
    }

    public InferenceVariable[] createInitialBoundSet(TypeVariableBinding[] typeParameters) {
        if (this.currentBounds == null) {
            this.currentBounds = new BoundSet();
        }
        if (typeParameters != null) {
            InferenceVariable[] newInferenceVariables = this.addInitialTypeVariableSubstitutions(typeParameters);
            this.currentBounds.addBoundsFromTypeParameters(this, typeParameters, newInferenceVariables);
            return newInferenceVariables;
        }
        return Binding.NO_INFERENCE_VARIABLES;
    }

    public TypeBinding substitute(TypeBinding type) {
        InferenceSubstitution inferenceSubstitution = new InferenceSubstitution(this.environment, this.inferenceVariables);
        return inferenceSubstitution.substitute((Substitution)inferenceSubstitution, type);
    }

    public void createInitialConstraintsForParameters(TypeBinding[] parameters, boolean checkVararg, TypeBinding varArgsType, MethodBinding method) {
        if (this.invocationArguments == null) {
            return;
        }
        int len = checkVararg ? parameters.length - 1 : Math.min(parameters.length, this.invocationArguments.length);
        int maxConstraints = checkVararg ? this.invocationArguments.length : len;
        int numConstraints = 0;
        if (this.initialConstraints == null) {
            this.initialConstraints = new ConstraintFormula[maxConstraints];
        } else {
            numConstraints = this.initialConstraints.length;
            this.initialConstraints = new ConstraintFormula[maxConstraints += numConstraints];
            System.arraycopy(this.initialConstraints, 0, this.initialConstraints, 0, numConstraints);
        }
        int i = 0;
        while (i < len) {
            if (this.invocationArguments[i].isPertinentToApplicability(parameters[i], method)) {
                TypeBinding thetaF = this.substitute(parameters[i]);
                this.initialConstraints[numConstraints++] = new ConstraintExpressionFormula(this.invocationArguments[i], thetaF, 1, false);
            }
            ++i;
        }
        if (checkVararg && varArgsType instanceof ArrayBinding) {
            TypeBinding thetaF = this.substitute(((ArrayBinding)varArgsType).elementsType());
            int i2 = len;
            while (i2 < this.invocationArguments.length) {
                if (this.invocationArguments[i2].isPertinentToApplicability(varArgsType, method)) {
                    this.initialConstraints[numConstraints++] = new ConstraintExpressionFormula(this.invocationArguments[i2], thetaF, 1, false);
                }
                ++i2;
            }
        }
        if (numConstraints == 0) {
            this.initialConstraints = ConstraintFormula.NO_CONSTRAINTS;
        } else if (numConstraints < maxConstraints) {
            this.initialConstraints = new ConstraintFormula[numConstraints];
            System.arraycopy(this.initialConstraints, 0, this.initialConstraints, 0, numConstraints);
        }
    }

    private InferenceVariable[] addInitialTypeVariableSubstitutions(TypeBinding[] typeVariables) {
        int len = typeVariables.length;
        if (len == 0) {
            if (this.inferenceVariables == null) {
                this.inferenceVariables = Binding.NO_INFERENCE_VARIABLES;
            }
            return Binding.NO_INFERENCE_VARIABLES;
        }
        InferenceVariable[] newVariables = new InferenceVariable[len];
        int i = 0;
        while (i < len) {
            newVariables[i] = new InferenceVariable(typeVariables[i], this.variableCount++, this.currentInvocation, this.environment, this.object);
            ++i;
        }
        if (this.inferenceVariables == null || this.inferenceVariables.length == 0) {
            this.inferenceVariables = newVariables;
        } else {
            int prev = this.inferenceVariables.length;
            this.inferenceVariables = new InferenceVariable[len + prev];
            System.arraycopy(this.inferenceVariables, 0, this.inferenceVariables, 0, prev);
            System.arraycopy(newVariables, 0, this.inferenceVariables, prev, len);
        }
        return newVariables;
    }

    public InferenceVariable[] addTypeVariableSubstitutions(TypeBinding[] typeVariables) {
        int len2 = typeVariables.length;
        InferenceVariable[] newVariables = new InferenceVariable[len2];
        int i = 0;
        while (i < typeVariables.length) {
            newVariables[i] = typeVariables[i] instanceof InferenceVariable ? (InferenceVariable)typeVariables[i] : new InferenceVariable(typeVariables[i], this.variableCount++, this.currentInvocation, this.environment, this.object);
            ++i;
        }
        int start = 0;
        if (this.inferenceVariables != null) {
            int len1 = this.inferenceVariables.length;
            this.inferenceVariables = new InferenceVariable[len1 + len2];
            System.arraycopy(this.inferenceVariables, 0, this.inferenceVariables, 0, len1);
            start = len1;
        } else {
            this.inferenceVariables = new InferenceVariable[len2];
        }
        System.arraycopy(newVariables, 0, this.inferenceVariables, start, len2);
        return newVariables;
    }

    public void addThrowsContraints(TypeBinding[] parameters, InferenceVariable[] variables, ReferenceBinding[] thrownExceptions) {
        int i = 0;
        while (i < parameters.length) {
            TypeBinding parameter = parameters[i];
            int j = 0;
            while (j < thrownExceptions.length) {
                if (TypeBinding.equalsEquals(parameter, thrownExceptions[j])) {
                    this.currentBounds.inThrows.add(variables[i]);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public void inferInvocationApplicability(MethodBinding method, TypeBinding[] arguments, boolean isDiamond) {
        ConstraintExpressionFormula.inferInvocationApplicability(this, method, arguments, isDiamond, this.inferenceKind);
    }

    /*
     * Unable to fully structure code
     */
    public BoundSet inferInvocationType(BoundSet b1, TypeBinding expectedType, InvocationSite invocationSite, MethodBinding method) throws InferenceFailureException {
        previous = this.currentBounds.copy();
        this.currentBounds = b1;
        try {
            if (expectedType != null && expectedType != TypeBinding.VOID && invocationSite instanceof Expression && ((Expression)invocationSite).isPolyExpression(method) && !ConstraintExpressionFormula.inferPolyInvocationType(this, invocationSite, expectedType, method)) {
                return null;
            }
            c = new HashSet<ConstraintFormula>();
            if (this.addConstraintsToC(this.invocationArguments, c, method, this.inferenceKind)) ** GOTO lbl32
            return null;
lbl-1000:
            // 1 sources

            {
                bottomSet = this.findBottomSet(c, this.allOutputVariables(c));
                if (bottomSet.isEmpty()) {
                    bottomSet.add(this.pickFromCycle(c));
                }
                c.removeAll(bottomSet);
                allInputs = new HashSet<InferenceVariable>();
                bottomIt = bottomSet.iterator();
                while (bottomIt.hasNext()) {
                    allInputs.addAll(bottomIt.next().inputVariables(this));
                }
                variablesArray = allInputs.toArray(new InferenceVariable[allInputs.size()]);
                this.currentBounds.incorporate(this);
                solution = this.resolve(variablesArray);
                if (solution == null) {
                    solution = this.resolve(this.inferenceVariables);
                }
                for (ConstraintFormula constraint : bottomSet) {
                    if (solution != null && !constraint.applySubstitution(solution, variablesArray)) {
                        return null;
                    }
                    if (this.currentBounds.reduceOneConstraint(this, constraint)) continue;
                    return null;
                }
lbl32:
                // 2 sources

                ** while (!c.isEmpty())
            }
lbl33:
            // 1 sources

            solution = this.solve();
            if (solution == null || !this.isResolved(solution)) {
                this.currentBounds = previous;
                return null;
            }
            this.reportUncheckedConversions(solution);
            var14_13 = this.currentBounds = solution;
            return var14_13;
        }
        finally {
            this.stepCompleted = 2;
        }
    }

    private boolean addConstraintsToC(Expression[] exprs, Set<ConstraintFormula> c, MethodBinding method, int inferenceKindForMethod) {
        if (exprs != null) {
            TypeBinding[] fs;
            int k = exprs.length;
            int p = method.parameters.length;
            if (k < (method.isVarargs() ? p - 1 : p)) {
                return false;
            }
            switch (inferenceKindForMethod) {
                case 1: 
                case 2: {
                    fs = method.parameters;
                    break;
                }
                case 3: {
                    fs = this.varArgTypes(method.parameters, k);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected checkKind " + this.inferenceKind);
                }
            }
            int i = 0;
            while (i < k) {
                TypeBinding substF;
                TypeBinding fsi = fs[Math.min(i, p - 1)];
                if (!this.addConstraintsToC_OneExpr(exprs[i], c, fsi, substF = this.substitute(fsi), method)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean addConstraintsToC_OneExpr(Expression expri, Set<ConstraintFormula> c, TypeBinding fsi, TypeBinding substF, MethodBinding method) {
        if (!expri.isPertinentToApplicability(fsi, method)) {
            c.add(new ConstraintExpressionFormula(expri, substF, 1, false));
        }
        if (expri instanceof FunctionalExpression) {
            c.add(new ConstraintExceptionFormula((FunctionalExpression)expri, substF));
        } else if (expri instanceof Invocation && expri.isPolyExpression()) {
            InferenceContext18 innerCtx;
            Invocation invocation = (Invocation)((Object)expri);
            MethodBinding innerMethod = invocation.binding(null, false, null);
            if (innerMethod instanceof ParameterizedGenericMethodBinding && (innerCtx = invocation.getInferenceContext((ParameterizedMethodBinding)innerMethod)) != null) {
                return this.addConstraintsToC(invocation.arguments(), c, innerMethod.genericMethod(), innerCtx.inferenceKind);
            }
        } else if (expri instanceof ConditionalExpression) {
            ConditionalExpression ce = (ConditionalExpression)expri;
            return this.addConstraintsToC_OneExpr(ce.valueIfTrue, c, fsi, substF, method) && this.addConstraintsToC_OneExpr(ce.valueIfFalse, c, fsi, substF, method);
        }
        return true;
    }

    MethodBinding inferInvocationType(Invocation invocation, TypeBinding[] argumentTypes, ParameterizedGenericMethodBinding method) {
        MethodBinding problemMethod;
        boolean haveProperTargetType;
        TypeBinding targetType = invocation.invocationTargetType();
        ParameterizedGenericMethodBinding finalMethod = null;
        ParameterizedGenericMethodBinding methodToCheck = method;
        boolean bl = haveProperTargetType = targetType != null && targetType.isProperType(true);
        if (haveProperTargetType || !invocation.getExpressionContext().definesTargetType()) {
            TypeBinding[] solutions;
            BoundSet result;
            MethodBinding original = method.originalMethod;
            Solution solution = this.solutionsPerTargetType.get(targetType);
            BoundSet boundSet = result = solution != null ? solution.bounds : null;
            if (result == null) {
                try {
                    result = this.inferInvocationType(this.currentBounds, targetType, invocation, original);
                }
                catch (InferenceFailureException inferenceFailureException) {}
            }
            if (result != null && (solutions = this.getSolutions(original.typeVariables(), invocation, result)) != null) {
                finalMethod = this.environment.createParameterizedGenericMethod(original, solutions);
                if (this.scope.compilerOptions().isAnnotationBasedNullAnalysisEnabled) {
                    NullAnnotationMatching.checkForContraditions(finalMethod, invocation, this.scope);
                }
                invocation.registerInferenceContext(finalMethod, this);
                this.solutionsPerTargetType.put(targetType, new Solution(finalMethod, result));
            }
            if (finalMethod != null) {
                methodToCheck = finalMethod;
            }
        } else {
            finalMethod = method;
        }
        if ((problemMethod = methodToCheck.boundCheck18(this.scope, argumentTypes)) != null) {
            return problemMethod;
        }
        if (!haveProperTargetType && invocation.getExpressionContext().definesTargetType()) {
            return method;
        }
        if (finalMethod != null && this.rebindInnerPolies(finalMethod, invocation)) {
            return finalMethod;
        }
        return this.getReturnProblemMethodIfNeeded(targetType, method);
    }

    public MethodBinding inferInvocationType(Invocation invocation, ParameterizedGenericMethodBinding method) {
        TypeBinding[] argumentTypes = null;
        Expression[] arguments = invocation.arguments();
        if (arguments != null) {
            argumentTypes = new TypeBinding[arguments.length];
            int i = 0;
            while (i < arguments.length) {
                argumentTypes[i] = arguments[i].resolvedType;
                ++i;
            }
        }
        return this.inferInvocationType(invocation, argumentTypes, method);
    }

    public boolean hasResultFor(TypeBinding targetType) {
        if (targetType == null) {
            return this.stepCompleted >= 2;
        }
        return this.solutionsPerTargetType.containsKey(targetType);
    }

    public boolean registerSolution(TypeBinding targetType, MethodBinding updatedBinding) {
        Solution solution = this.solutionsPerTargetType.get(targetType);
        if (solution != null) {
            return false;
        }
        this.solutionsPerTargetType.put(targetType, new Solution(updatedBinding, null));
        this.stepCompleted = Math.max(this.stepCompleted, 2);
        return true;
    }

    public ReferenceBinding inferFunctionalInterfaceParameterization(LambdaExpression lambda, BlockScope blockScope, ParameterizedTypeBinding targetTypeWithWildCards) {
        TypeBinding[] q = this.createBoundsForFunctionalInterfaceParameterizationInference(targetTypeWithWildCards);
        if (q != null && q.length == lambda.arguments().length && this.reduceWithEqualityConstraints(lambda.argumentTypes(), q)) {
            ReferenceBinding genericType = targetTypeWithWildCards.genericType();
            TypeBinding[] a = targetTypeWithWildCards.arguments;
            TypeBinding[] aprime = this.getFunctionInterfaceArgumentSolutions(a);
            return blockScope.environment().createParameterizedType(genericType, aprime, genericType.enclosingType());
        }
        return targetTypeWithWildCards;
    }

    TypeBinding[] createBoundsForFunctionalInterfaceParameterizationInference(ParameterizedTypeBinding functionalInterface) {
        TypeBinding[] a;
        if (this.currentBounds == null) {
            this.currentBounds = new BoundSet();
        }
        if ((a = functionalInterface.arguments) == null) {
            return null;
        }
        InferenceVariable[] alpha = this.addInitialTypeVariableSubstitutions(a);
        int i = 0;
        while (i < a.length) {
            block10: {
                TypeBound bound;
                block9: {
                    block8: {
                        if (a[i].kind() != 516) break block8;
                        WildcardBinding wildcard = (WildcardBinding)a[i];
                        switch (wildcard.boundKind) {
                            case 1: {
                                bound = new TypeBound(alpha[i], wildcard.allBounds(), 2);
                                break block9;
                            }
                            case 2: {
                                bound = new TypeBound(alpha[i], wildcard.bound, 3);
                                break block9;
                            }
                            case 0: {
                                bound = new TypeBound(alpha[i], this.object, 2);
                                break block9;
                            }
                        }
                        break block10;
                    }
                    bound = new TypeBound(alpha[i], a[i], 4);
                }
                this.currentBounds.addBound(bound, this.environment);
            }
            ++i;
        }
        TypeBinding falpha = this.substitute(functionalInterface);
        return falpha.getSingleAbstractMethod((Scope)this.scope, (boolean)true).parameters;
    }

    public boolean reduceWithEqualityConstraints(TypeBinding[] p, TypeBinding[] q) {
        if (p != null) {
            int i = 0;
            while (i < p.length) {
                try {
                    if (!this.reduceAndIncorporate(ConstraintTypeFormula.create(p[i], q[i], 4))) {
                        return false;
                    }
                }
                catch (InferenceFailureException inferenceFailureException) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isMoreSpecificThan(MethodBinding m1, MethodBinding m2, boolean isVarArgs, boolean isVarArgs2) {
        if (isVarArgs != isVarArgs2) {
            return isVarArgs2;
        }
        Expression[] arguments = this.invocationArguments;
        int numInvocArgs = arguments == null ? 0 : arguments.length;
        TypeVariableBinding[] p = m2.typeVariables();
        TypeBinding[] s = m1.parameters;
        TypeBinding[] t = new TypeBinding[m2.parameters.length];
        this.createInitialBoundSet(p);
        int i = 0;
        while (i < t.length) {
            t[i] = this.substitute(m2.parameters[i]);
            ++i;
        }
        try {
            i = 0;
            while (true) {
                TypeBinding ti;
                if (i >= numInvocArgs) {
                    TypeBinding tkplus1;
                    TypeBinding skplus1;
                    if (t.length != numInvocArgs + 1 || this.reduceAndIncorporate(ConstraintTypeFormula.create(skplus1 = InferenceContext18.getParameter(s, numInvocArgs, true), tkplus1 = InferenceContext18.getParameter(t, numInvocArgs, true), 2))) break;
                    return false;
                }
                TypeBinding si = InferenceContext18.getParameter(s, i, isVarArgs);
                Boolean result = this.moreSpecificMain(si, ti = InferenceContext18.getParameter(t, i, isVarArgs), this.invocationArguments[i]);
                if (result == Boolean.FALSE) {
                    return false;
                }
                if (result == null && !this.reduceAndIncorporate(ConstraintTypeFormula.create(si, ti, 2))) {
                    return false;
                }
                ++i;
            }
            return this.solve() != null;
        }
        catch (InferenceFailureException inferenceFailureException) {
            return false;
        }
    }

    private Boolean moreSpecificMain(TypeBinding si, TypeBinding ti, Expression expri) throws InferenceFailureException {
        TypeBinding funcI;
        if (si.isProperType(true) && ti.isProperType(true)) {
            return expri.sIsMoreSpecific(si, ti, this.scope) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (si.isFunctionalInterface(this.scope) && (funcI = ti.original()).isFunctionalInterface(this.scope)) {
            if (this.siSuperI(si, funcI) || this.siSubI(si, funcI)) {
                return null;
            }
            if (si instanceof IntersectionCastTypeBinding) {
                int i;
                ReferenceBinding[] elements;
                block8: {
                    elements = ((IntersectionCastTypeBinding)si).intersectingTypes;
                    i = 0;
                    while (i < elements.length) {
                        if (this.siSuperI(elements[i], funcI)) {
                            ++i;
                            continue;
                        }
                        break block8;
                    }
                    return null;
                }
                i = 0;
                while (i < elements.length) {
                    if (this.siSubI(elements[i], funcI)) {
                        return null;
                    }
                    ++i;
                }
            }
            TypeBinding siCapture = si.capture(this.scope, this.captureId++);
            MethodBinding sam = siCapture.getSingleAbstractMethod(this.scope, false);
            TypeBinding[] u = sam.parameters;
            TypeBinding r1 = sam.isConstructor() ? sam.declaringClass : sam.returnType;
            sam = ti.getSingleAbstractMethod(this.scope, true);
            TypeBinding[] v = sam.parameters;
            TypeBinding r2 = sam.isConstructor() ? sam.declaringClass : sam.returnType;
            return this.checkExpression(expri, u, r1, v, r2);
        }
        return null;
    }

    private boolean checkExpression(Expression expri, TypeBinding[] u, TypeBinding r1, TypeBinding[] v, TypeBinding r2) throws InferenceFailureException {
        if (expri instanceof LambdaExpression && !((LambdaExpression)expri).argumentsTypeElided()) {
            block19: {
                int i;
                Expression[] results;
                block18: {
                    if (r2.id == 6) {
                        return true;
                    }
                    LambdaExpression lambda = (LambdaExpression)expri;
                    results = lambda.resultExpressions();
                    if (r1.isFunctionalInterface(this.scope) && r2.isFunctionalInterface(this.scope) && !r1.isCompatibleWith(r2) && !r2.isCompatibleWith(r1)) {
                        int i2 = 0;
                        while (i2 < results.length) {
                            if (!this.checkExpression(results[i2], u, r1, v, r2)) {
                                return false;
                            }
                            ++i2;
                        }
                        return true;
                    }
                    if (r1.isPrimitiveType() && !r2.isPrimitiveType()) {
                        i = 0;
                        while (i < results.length) {
                            if (!results[i].isPolyExpression() && (results[i].resolvedType == null || results[i].resolvedType.isPrimitiveType())) {
                                ++i;
                                continue;
                            }
                            break block18;
                        }
                        return true;
                    }
                }
                if (r2.isPrimitiveType() && !r1.isPrimitiveType()) {
                    i = 0;
                    while (i < results.length) {
                        if (!results[i].isPolyExpression() && results[i].resolvedType != null && !results[i].resolvedType.isPrimitiveType() || results[i].isPolyExpression()) {
                            ++i;
                            continue;
                        }
                        break block19;
                    }
                    return true;
                }
            }
            return this.reduceAndIncorporate(ConstraintTypeFormula.create(r1, r2, 2));
        }
        if (expri instanceof ReferenceExpression && ((ReferenceExpression)expri).isExactMethodReference()) {
            int i = 0;
            while (i < u.length) {
                TypeBinding returnType;
                ReferenceExpression reference = (ReferenceExpression)expri;
                if (!this.reduceAndIncorporate(ConstraintTypeFormula.create(u[i], v[i], 4))) {
                    return false;
                }
                if (r2.id == 6) {
                    return true;
                }
                MethodBinding method = reference.findCompileTimeMethodTargeting(null, this.scope);
                TypeBinding typeBinding = returnType = method.isConstructor() ? method.declaringClass : method.returnType;
                if (r1.isPrimitiveType() && !r2.isPrimitiveType() && returnType.isPrimitiveType()) {
                    return true;
                }
                if (r2.isPrimitiveType() && !r1.isPrimitiveType() && !returnType.isPrimitiveType()) {
                    return true;
                }
                ++i;
            }
            return this.reduceAndIncorporate(ConstraintTypeFormula.create(r1, r2, 2));
        }
        if (expri instanceof ConditionalExpression) {
            ConditionalExpression cond = (ConditionalExpression)expri;
            return this.checkExpression(cond.valueIfTrue, u, r1, v, r2) && this.checkExpression(cond.valueIfFalse, u, r1, v, r2);
        }
        return false;
    }

    private boolean siSuperI(TypeBinding si, TypeBinding funcI) {
        if (TypeBinding.equalsEquals(si, funcI) || TypeBinding.equalsEquals(si.original(), funcI)) {
            return true;
        }
        ReferenceBinding[] superIfcs = funcI.superInterfaces();
        if (superIfcs == null) {
            return false;
        }
        int i = 0;
        while (i < superIfcs.length) {
            if (this.siSuperI(si, superIfcs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean siSubI(TypeBinding si, TypeBinding funcI) {
        if (TypeBinding.equalsEquals(si, funcI) || TypeBinding.equalsEquals(si.original(), funcI)) {
            return true;
        }
        ReferenceBinding[] superIfcs = si.superInterfaces();
        if (superIfcs == null) {
            return false;
        }
        int i = 0;
        while (i < superIfcs.length) {
            if (this.siSubI(superIfcs[i], funcI)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public BoundSet solve() throws InferenceFailureException {
        if (!this.reduce()) {
            return null;
        }
        if (!this.currentBounds.incorporate(this)) {
            return null;
        }
        return this.resolve(this.inferenceVariables);
    }

    public BoundSet solve(InferenceVariable[] toResolve) throws InferenceFailureException {
        if (!this.reduce()) {
            return null;
        }
        if (!this.currentBounds.incorporate(this)) {
            return null;
        }
        return this.resolve(toResolve);
    }

    private boolean reduce() throws InferenceFailureException {
        if (this.initialConstraints != null) {
            int i = 0;
            while (i < this.initialConstraints.length) {
                if (!this.currentBounds.reduceOneConstraint(this, this.initialConstraints[i])) {
                    return false;
                }
                ++i;
            }
        }
        this.initialConstraints = null;
        return true;
    }

    public boolean isResolved(BoundSet boundSet) {
        if (this.inferenceVariables != null) {
            int i = 0;
            while (i < this.inferenceVariables.length) {
                if (!boundSet.isInstantiated(this.inferenceVariables[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public TypeBinding[] getSolutions(TypeVariableBinding[] typeParameters, InvocationSite site, BoundSet boundSet) {
        int len = typeParameters.length;
        TypeBinding[] substitutions = new TypeBinding[len];
        int i = 0;
        while (i < typeParameters.length) {
            int j = 0;
            while (j < this.inferenceVariables.length) {
                InferenceVariable variable = this.inferenceVariables[j];
                if (variable.site == site && TypeBinding.equalsEquals(variable.typeParameter, typeParameters[i])) {
                    substitutions[i] = boundSet.getInstantiation(variable, this.environment);
                    break;
                }
                ++j;
            }
            if (substitutions[i] == null) {
                return null;
            }
            ++i;
        }
        return substitutions;
    }

    public boolean reduceAndIncorporate(ConstraintFormula constraint) throws InferenceFailureException {
        return this.currentBounds.reduceOneConstraint(this, constraint);
    }

    private BoundSet resolve(InferenceVariable[] toResolve) throws InferenceFailureException {
        BoundSet tmpBoundSet;
        block25: {
            Set<InferenceVariable> variableSet;
            this.captureId = 0;
            tmpBoundSet = this.currentBounds;
            if (this.inferenceVariables == null) break block25;
            while ((variableSet = this.getSmallestVariableSet(tmpBoundSet, toResolve)) != null) {
                int j;
                int oldNumUninstantiated = tmpBoundSet.numUninstantiatedVariables(this.inferenceVariables);
                final int numVars = variableSet.size();
                if (numVars <= 0) continue;
                final InferenceVariable[] variables = variableSet.toArray(new InferenceVariable[numVars]);
                if (!tmpBoundSet.hasCaptureBound(variableSet)) {
                    BoundSet prevBoundSet = tmpBoundSet;
                    tmpBoundSet = tmpBoundSet.copy();
                    j = 0;
                    while (j < variables.length) {
                        InferenceVariable variable = variables[j];
                        TypeBinding[] lowerBounds = tmpBoundSet.lowerBounds(variable, true);
                        if (lowerBounds != Binding.NO_TYPES) {
                            TypeBinding lub = this.scope.lowerUpperBound(lowerBounds);
                            if (lub == TypeBinding.VOID || lub == null) {
                                return null;
                            }
                            tmpBoundSet.addBound(new TypeBound(variable, lub, 4), this.environment);
                        } else {
                            TypeBinding[] upperBounds = tmpBoundSet.upperBounds(variable, true);
                            if (tmpBoundSet.inThrows.contains(variable) && tmpBoundSet.hasOnlyTrivialExceptionBounds(variable, upperBounds)) {
                                TypeBinding runtimeException = this.scope.getType(TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION, 3);
                                tmpBoundSet.addBound(new TypeBound(variable, runtimeException, 4), this.environment);
                            } else {
                                TypeBinding glb = this.object;
                                if (upperBounds != Binding.NO_TYPES) {
                                    if (upperBounds.length == 1) {
                                        glb = upperBounds[0];
                                    } else {
                                        ReferenceBinding[] glbs = Scope.greaterLowerBound((ReferenceBinding[])upperBounds);
                                        if (glbs == null) {
                                            throw new UnsupportedOperationException("no glb for " + Arrays.asList(upperBounds));
                                        }
                                        glb = glbs.length == 1 ? glbs[0] : new IntersectionCastTypeBinding(glbs, this.environment);
                                    }
                                }
                                tmpBoundSet.addBound(new TypeBound(variable, glb, 4), this.environment);
                            }
                        }
                        ++j;
                    }
                    if (tmpBoundSet.incorporate(this)) continue;
                    tmpBoundSet = prevBoundSet;
                }
                Sorting.sortInferenceVariables(variables);
                final CaptureBinding18[] zs = new CaptureBinding18[numVars];
                j = 0;
                while (j < numVars) {
                    zs[j] = this.freshCapture(variables[j]);
                    ++j;
                }
                Substitution theta = new Substitution(){

                    @Override
                    public LookupEnvironment environment() {
                        return InferenceContext18.this.environment;
                    }

                    @Override
                    public boolean isRawSubstitution() {
                        return false;
                    }

                    @Override
                    public TypeBinding substitute(TypeVariableBinding typeVariable) {
                        int j = 0;
                        while (j < numVars) {
                            if (variables[j] == typeVariable) {
                                return zs[j];
                            }
                            ++j;
                        }
                        return typeVariable;
                    }
                };
                int j2 = 0;
                while (j2 < numVars) {
                    block27: {
                        CaptureBinding18 zsj;
                        InferenceVariable variable;
                        block26: {
                            TypeBinding[] upperBounds;
                            TypeBinding lub;
                            variable = variables[j2];
                            zsj = zs[j2];
                            TypeBinding[] lowerBounds = tmpBoundSet.lowerBounds(variable, true);
                            if (lowerBounds != Binding.NO_TYPES && (lub = this.scope.lowerUpperBound(lowerBounds = Scope.substitute(theta, lowerBounds))) != TypeBinding.VOID && lub != null) {
                                zsj.lowerBound = lub;
                            }
                            if ((upperBounds = tmpBoundSet.upperBounds(variable, false)) == Binding.NO_TYPES) break block26;
                            int k = 0;
                            while (k < upperBounds.length) {
                                upperBounds[k] = Scope.substitute(theta, upperBounds[k]);
                                ++k;
                            }
                            if (!this.setUpperBounds(zsj, upperBounds)) break block27;
                        }
                        if (tmpBoundSet == this.currentBounds) {
                            tmpBoundSet = tmpBoundSet.copy();
                        }
                        Iterator<ParameterizedTypeBinding> captureKeys = tmpBoundSet.captures.keySet().iterator();
                        HashSet<ParameterizedTypeBinding> toRemove = new HashSet<ParameterizedTypeBinding>();
                        block5: while (captureKeys.hasNext()) {
                            ParameterizedTypeBinding key = captureKeys.next();
                            int len = key.arguments.length;
                            int i = 0;
                            while (i < len) {
                                if (key.arguments[i] == variable) {
                                    toRemove.add(key);
                                    continue block5;
                                }
                                ++i;
                            }
                        }
                        captureKeys = toRemove.iterator();
                        while (captureKeys.hasNext()) {
                            tmpBoundSet.captures.remove(captureKeys.next());
                        }
                        tmpBoundSet.addBound(new TypeBound(variable, zsj, 4), this.environment);
                    }
                    ++j2;
                }
                if (tmpBoundSet.incorporate(this)) {
                    if (tmpBoundSet.numUninstantiatedVariables(this.inferenceVariables) != oldNumUninstantiated) continue;
                    return null;
                }
                return null;
            }
        }
        return tmpBoundSet;
    }

    private CaptureBinding18 freshCapture(InferenceVariable variable) {
        int id = this.captureId++;
        char[] sourceName = CharOperation.concat("Z".toCharArray(), '#', String.valueOf(id).toCharArray(), '-', variable.sourceName);
        int position = this.currentInvocation != null ? this.currentInvocation.sourceStart() : 0;
        return new CaptureBinding18(this.scope.enclosingSourceType(), sourceName, variable.typeParameter.shortReadableName(), position, id, this.environment);
    }

    private boolean setUpperBounds(CaptureBinding18 typeVariable, TypeBinding[] substitutedUpperBounds) {
        if (substitutedUpperBounds.length == 1) {
            typeVariable.setUpperBounds(substitutedUpperBounds, this.object);
        } else {
            TypeBinding[] glbs = Scope.greaterLowerBound(substitutedUpperBounds, this.scope, this.environment);
            if (glbs == null) {
                return false;
            }
            if (typeVariable.lowerBound != null) {
                int i = 0;
                while (i < glbs.length) {
                    if (!typeVariable.lowerBound.isCompatibleWith(glbs[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            InferenceContext18.sortTypes(glbs);
            if (!typeVariable.setUpperBounds(glbs, this.object)) {
                return false;
            }
        }
        return true;
    }

    static void sortTypes(TypeBinding[] types) {
        Arrays.sort(types, new Comparator<TypeBinding>(){

            @Override
            public int compare(TypeBinding o1, TypeBinding o2) {
                int i1 = o1.id;
                int i2 = o2.id;
                return i1 < i2 ? -1 : (i1 == i2 ? 0 : 1);
            }
        });
    }

    private Set<InferenceVariable> getSmallestVariableSet(BoundSet bounds, InferenceVariable[] subSet) {
        int min = Integer.MAX_VALUE;
        HashSet<InferenceVariable> result = null;
        int i = 0;
        while (i < subSet.length) {
            HashSet<InferenceVariable> set;
            InferenceVariable currentVariable = subSet[i];
            if (!bounds.isInstantiated(currentVariable) && this.addDependencies(bounds, set = new HashSet<InferenceVariable>(), currentVariable, min)) {
                int cur = set.size();
                if (cur == 1) {
                    return set;
                }
                if (cur < min) {
                    result = set;
                    min = cur;
                }
            }
            ++i;
        }
        return result;
    }

    private boolean addDependencies(BoundSet boundSet, Set<InferenceVariable> variableSet, InferenceVariable currentVariable, int min) {
        if (variableSet.size() >= min) {
            return false;
        }
        if (boundSet.isInstantiated(currentVariable)) {
            return true;
        }
        if (!variableSet.add(currentVariable)) {
            return true;
        }
        int j = 0;
        while (j < this.inferenceVariables.length) {
            InferenceVariable nextVariable = this.inferenceVariables[j];
            if (nextVariable != currentVariable && boundSet.dependsOnResolutionOf(currentVariable, nextVariable) && !this.addDependencies(boundSet, variableSet, nextVariable, min)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private ConstraintFormula pickFromCycle(Set<ConstraintFormula> c) {
        HashMap<ConstraintFormula, Set<ConstraintFormula>> dependencies = new HashMap<ConstraintFormula, Set<ConstraintFormula>>();
        HashSet cycles = new HashSet();
        for (ConstraintFormula constraint : c) {
            Collection<InferenceVariable> infVars = constraint.inputVariables(this);
            for (ConstraintFormula constraintFormula : c) {
                void var9_19;
                if (constraintFormula == constraint || !this.dependsOn(infVars, constraintFormula.outputVariables(this))) continue;
                Set set = (Set)dependencies.get(constraint);
                if (set == null) {
                    HashSet hashSet = new HashSet();
                    dependencies.put(constraint, hashSet);
                }
                var9_19.add(constraintFormula);
                HashSet nodesInCycle = new HashSet();
                if (!this.isReachable(dependencies, constraintFormula, constraint, new HashSet<ConstraintFormula>(), nodesInCycle)) continue;
                cycles.addAll(nodesInCycle);
            }
        }
        HashSet<ConstraintFormula> outside = new HashSet<ConstraintFormula>(c);
        outside.removeAll(cycles);
        Set<Object> candidatesII = new HashSet();
        block2: for (ConstraintFormula candidate : cycles) {
            Collection<InferenceVariable> collection = candidate.inputVariables(this);
            for (ConstraintFormula constraintFormula : outside) {
                if (this.dependsOn(collection, constraintFormula.outputVariables(this))) continue block2;
            }
            candidatesII.add(candidate);
        }
        if (candidatesII.isEmpty()) {
            candidatesII = c;
        }
        Set<Object> candidatesIII = new HashSet();
        for (ConstraintFormula constraintFormula : candidatesII) {
            if (!(constraintFormula instanceof ConstraintExpressionFormula)) continue;
            candidatesIII.add(constraintFormula);
        }
        if (candidatesIII.isEmpty()) {
            candidatesIII = candidatesII;
        } else {
            HashMap<ConstraintExpressionFormula, ConstraintExpressionFormula> hashMap = new HashMap<ConstraintExpressionFormula, ConstraintExpressionFormula>();
            for (ConstraintFormula constraintFormula : candidatesIII) {
                ConstraintExpressionFormula oneCEF = (ConstraintExpressionFormula)constraintFormula;
                Expression exprOne = oneCEF.left;
                for (ConstraintFormula constraintFormula2 : candidatesIII) {
                    ConstraintExpressionFormula previous;
                    if (constraintFormula == constraintFormula2) continue;
                    ConstraintExpressionFormula twoCEF = (ConstraintExpressionFormula)constraintFormula2;
                    Expression exprTwo = twoCEF.left;
                    if (!this.doesExpressionContain(exprOne, exprTwo) || (previous = (ConstraintExpressionFormula)hashMap.get(constraintFormula2)) != null && !this.doesExpressionContain(previous.left, exprOne)) continue;
                    hashMap.put(twoCEF, oneCEF);
                }
            }
            HashMap<ConstraintExpressionFormula, Set<ConstraintExpressionFormula>> hashMap2 = new HashMap<ConstraintExpressionFormula, Set<ConstraintExpressionFormula>>();
            for (Map.Entry entry : hashMap.entrySet()) {
                void var12_35;
                ConstraintExpressionFormula parent = (ConstraintExpressionFormula)entry.getValue();
                Set set = (Set)hashMap2.get(parent);
                if (set == null) {
                    HashSet hashSet = new HashSet();
                    hashMap2.put(parent, hashSet);
                }
                var12_35.add((ConstraintExpressionFormula)entry.getKey());
            }
            int n = -1;
            ConstraintExpressionFormula candidate = null;
            for (ConstraintExpressionFormula parent : hashMap2.keySet()) {
                int n2;
                int rank = this.rankNode(parent, hashMap, hashMap2);
                if (rank <= n2) continue;
                n2 = rank;
                candidate = parent;
            }
            if (candidate != null) {
                return candidate;
            }
        }
        if (candidatesIII.isEmpty()) {
            throw new IllegalStateException("cannot pick constraint from cyclic set");
        }
        return (ConstraintFormula)candidatesIII.iterator().next();
    }

    private boolean dependsOn(Collection<InferenceVariable> inputsOfFirst, Collection<InferenceVariable> outputsOfOther) {
        for (InferenceVariable iv : inputsOfFirst) {
            for (InferenceVariable otherIV : outputsOfOther) {
                if (!this.currentBounds.dependsOnResolutionOf(iv, otherIV)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isReachable(Map<ConstraintFormula, Set<ConstraintFormula>> deps, ConstraintFormula from, ConstraintFormula to, Set<ConstraintFormula> nodesVisited, Set<ConstraintFormula> nodesInCycle) {
        if (from == to) {
            nodesInCycle.add(from);
            return true;
        }
        if (!nodesVisited.add(from)) {
            return false;
        }
        Set<ConstraintFormula> targetSet = deps.get(from);
        if (targetSet != null) {
            for (ConstraintFormula tgt : targetSet) {
                if (!this.isReachable(deps, tgt, to, nodesVisited, nodesInCycle)) continue;
                nodesInCycle.add(from);
                return true;
            }
        }
        return false;
    }

    private boolean doesExpressionContain(Expression exprOne, Expression exprTwo) {
        if (exprTwo.sourceStart > exprOne.sourceStart) {
            return exprTwo.sourceEnd <= exprOne.sourceEnd;
        }
        if (exprTwo.sourceStart == exprOne.sourceStart) {
            return exprTwo.sourceEnd < exprOne.sourceEnd;
        }
        return false;
    }

    private int rankNode(ConstraintExpressionFormula parent, Map<ConstraintExpressionFormula, ConstraintExpressionFormula> expressionContainedBy, Map<ConstraintExpressionFormula, Set<ConstraintExpressionFormula>> containmentForest) {
        if (expressionContainedBy.get(parent) != null) {
            return -1;
        }
        Set<ConstraintExpressionFormula> children = containmentForest.get(parent);
        if (children == null) {
            return 1;
        }
        int sum = 1;
        for (ConstraintExpressionFormula child : children) {
            int cRank = this.rankNode(child, expressionContainedBy, containmentForest);
            if (cRank <= 0) continue;
            sum += cRank;
        }
        return sum;
    }

    /*
     * Unable to fully structure code
     */
    private Set<ConstraintFormula> findBottomSet(Set<ConstraintFormula> constraints, Set<InferenceVariable> allOutputVariables) {
        result = new HashSet<ConstraintFormula>();
        block0: for (ConstraintFormula constraint : constraints) {
            inputIt = constraint.inputVariables(this).iterator();
            outputIt = allOutputVariables.iterator();
            block1: while (inputIt.hasNext()) {
                in = inputIt.next();
                if (!allOutputVariables.contains(in)) ** GOTO lbl-1000
                continue block0;
                while (!this.currentBounds.dependsOnResolutionOf(in, outputIt.next())) lbl-1000:
                // 2 sources

                {
                    if (outputIt.hasNext()) continue;
                    continue block1;
                }
                continue block0;
            }
            result.add(constraint);
        }
        return result;
    }

    Set<InferenceVariable> allOutputVariables(Set<ConstraintFormula> constraints) {
        HashSet<InferenceVariable> result = new HashSet<InferenceVariable>();
        Iterator<ConstraintFormula> it = constraints.iterator();
        while (it.hasNext()) {
            result.addAll(it.next().outputVariables(this));
        }
        return result;
    }

    private TypeBinding[] varArgTypes(TypeBinding[] parameters, int k) {
        TypeBinding[] types = new TypeBinding[k];
        int declaredLength = parameters.length - 1;
        System.arraycopy(parameters, 0, types, 0, declaredLength);
        TypeBinding last = ((ArrayBinding)parameters[declaredLength]).elementsType();
        int i = declaredLength;
        while (i < k) {
            types[i] = last;
            ++i;
        }
        return types;
    }

    public SuspendedInferenceRecord enterPolyInvocation(InvocationSite invocation, Expression[] innerArguments) {
        SuspendedInferenceRecord record = new SuspendedInferenceRecord(this.currentInvocation, this.invocationArguments, this.inferenceVariables, this.inferenceKind);
        this.inferenceVariables = null;
        this.invocationArguments = innerArguments;
        this.currentInvocation = invocation;
        this.innerPolies.add(invocation);
        return record;
    }

    public SuspendedInferenceRecord enterLambda(LambdaExpression lambda) {
        SuspendedInferenceRecord record = new SuspendedInferenceRecord(this.currentInvocation, this.invocationArguments, this.inferenceVariables, this.inferenceKind);
        this.inferenceVariables = null;
        this.invocationArguments = null;
        this.currentInvocation = null;
        return record;
    }

    public void resumeSuspendedInference(SuspendedInferenceRecord record) {
        if (this.inferenceVariables == null) {
            this.inferenceVariables = record.inferenceVariables;
        } else {
            int l1 = this.inferenceVariables.length;
            int l2 = record.inferenceVariables.length;
            this.inferenceVariables = new InferenceVariable[l1 + l2];
            System.arraycopy(this.inferenceVariables, 0, this.inferenceVariables, l2, l1);
            System.arraycopy(record.inferenceVariables, 0, this.inferenceVariables, 0, l2);
        }
        this.currentInvocation = record.site;
        this.invocationArguments = record.invocationArguments;
        this.inferenceKind = record.inferenceKind;
    }

    public boolean rebindInnerPolies(MethodBinding method, InvocationSite site) {
        BoundSet bounds = this.currentBounds;
        TypeBinding targetType = site.invocationTargetType();
        if (targetType == null || !targetType.isProperType(true)) {
            if (!site.getExpressionContext().definesTargetType()) {
                Solution solution = this.solutionsPerTargetType.get(targetType);
                try {
                    bounds = solution != null && solution.bounds != null ? solution.bounds : this.inferInvocationType(this.currentBounds, null, site, method.shallowOriginal());
                }
                catch (InferenceFailureException inferenceFailureException) {
                    return false;
                }
                if (bounds == null) {
                    return false;
                }
            }
        } else {
            Solution solution = this.solutionsPerTargetType.get(targetType);
            if (solution != null && solution.bounds != null) {
                bounds = solution.bounds;
            }
        }
        this.rebindInnerPolies(bounds, method.parameters);
        return true;
    }

    public void rebindInnerPolies(BoundSet bounds, TypeBinding[] parameterTypes) {
        boolean isVarargs = this.inferenceKind == 3;
        this.acceptPendingPolyArguments(bounds, parameterTypes, isVarargs);
        int len = this.innerPolies.size();
        int i = 0;
        while (i < len) {
            Expression inner = (Expression)((Object)this.innerPolies.get(i));
            if (inner instanceof Invocation) {
                MethodBinding binding;
                Invocation innerMessage = (Invocation)((Object)inner);
                TypeBinding innerTargetType = inner.expectedType();
                if (innerTargetType != null && !innerTargetType.isProperType(true)) {
                    innerTargetType = null;
                }
                if ((binding = innerMessage.binding(innerTargetType, innerTargetType != null, this.scope)) != null) {
                    TypeBinding[] solutions;
                    MethodBinding original = binding.shallowOriginal();
                    if (original.isConstructor() && inner.isPolyExpression()) {
                        ReferenceBinding declaringClass = original.declaringClass;
                        TypeBinding[] arguments = this.getSolutions(declaringClass.typeVariables(), innerMessage, bounds);
                        declaringClass = this.environment.createParameterizedType(declaringClass, arguments, declaringClass.enclosingType());
                        original = ((ParameterizedTypeBinding)declaringClass).createParameterizedMethod(original);
                        inner.checkAgainstFinalTargetType(innerTargetType, this.scope);
                        if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
                            NullAnnotationMatching.checkForContraditions(original, innerMessage, this.scope);
                        }
                    }
                    if ((solutions = this.getSolutions(original.typeVariables(), innerMessage, bounds)) == null) {
                        InferenceContext18 innerCtx;
                        if (binding instanceof ParameterizedGenericMethodBinding && (innerCtx = innerMessage.getInferenceContext((ParameterizedGenericMethodBinding)binding)) != null && !binding.isValidBinding()) {
                            innerCtx.reportInvalidInvocation(innerMessage, binding);
                        }
                    } else {
                        ParameterizedGenericMethodBinding innerBinding = this.environment.createParameterizedGenericMethod(original, solutions);
                        if (innerMessage.updateBindings(innerBinding, innerTargetType)) {
                            ASTNode.resolvePolyExpressionArguments(innerMessage, innerBinding, this.scope);
                        }
                    }
                }
            }
            ++i;
        }
        this.stepCompleted = 3;
    }

    private void acceptPendingPolyArguments(BoundSet acceptedResult, TypeBinding[] parameterTypes, boolean isVarArgs) {
        if (acceptedResult == null || this.invocationArguments == null) {
            return;
        }
        Substitution substitution = this.getResultSubstitution(acceptedResult);
        int i = 0;
        while (i < this.invocationArguments.length) {
            Expression expression;
            TypeBinding targetType = InferenceContext18.getParameter(parameterTypes, i, isVarArgs);
            if (!targetType.isProperType(true)) {
                targetType = Scope.substitute(substitution, targetType);
            }
            if ((expression = this.invocationArguments[i]) instanceof Invocation) {
                Invocation invocation = (Invocation)((Object)expression);
                if (!this.innerPolies.contains(invocation)) {
                    ParameterizedGenericMethodBinding previousBinding;
                    InferenceContext18 innerCtx;
                    MethodBinding method = invocation.binding(targetType, true, this.scope);
                    if (method instanceof ParameterizedGenericMethodBinding && (innerCtx = invocation.getInferenceContext(previousBinding = (ParameterizedGenericMethodBinding)method)) != null) {
                        MethodBinding innerBinding = innerCtx.inferInvocationType(invocation, previousBinding);
                        if (!innerBinding.isValidBinding()) {
                            innerCtx.reportInvalidInvocation(invocation, innerBinding);
                        }
                        if (invocation.updateBindings(innerBinding, targetType)) {
                            ASTNode.resolvePolyExpressionArguments(invocation, innerBinding, this.scope);
                        }
                    }
                } else {
                    expression.setExpectedType(targetType);
                }
            } else {
                expression.checkAgainstFinalTargetType(targetType, this.scope);
            }
            ++i;
        }
    }

    private Substitution getResultSubstitution(final BoundSet result) {
        return new Substitution(){

            @Override
            public LookupEnvironment environment() {
                return InferenceContext18.this.environment;
            }

            @Override
            public boolean isRawSubstitution() {
                return false;
            }

            @Override
            public TypeBinding substitute(TypeVariableBinding typeVariable) {
                if (typeVariable instanceof InferenceVariable) {
                    return result.getInstantiation((InferenceVariable)typeVariable, InferenceContext18.this.environment);
                }
                return typeVariable;
            }
        };
    }

    public boolean isVarArgs() {
        return this.inferenceKind == 3;
    }

    public static TypeBinding getParameter(TypeBinding[] parameters, int rank, boolean isVarArgs) {
        if (isVarArgs) {
            if (rank >= parameters.length - 1) {
                return ((ArrayBinding)parameters[parameters.length - 1]).elementsType();
            }
        } else if (rank >= parameters.length) {
            return null;
        }
        return parameters[rank];
    }

    public MethodBinding getReturnProblemMethodIfNeeded(TypeBinding expectedType, MethodBinding method) {
        if (expectedType != null && method.returnType instanceof ReferenceBinding && method.returnType.erasure().isCompatibleWith(expectedType)) {
            return method;
        }
        if (expectedType == null) {
            return method;
        }
        ProblemMethodBinding problemMethod = new ProblemMethodBinding(method, method.selector, method.parameters, 23);
        problemMethod.returnType = expectedType;
        problemMethod.inferenceContext = this;
        return problemMethod;
    }

    public void reportInvalidInvocation(Invocation invocation, MethodBinding binding) {
        if (invocation instanceof MessageSend) {
            this.scope.problemReporter().invalidMethod((MessageSend)invocation, binding);
        } else {
            this.scope.problemReporter().invalidConstructor((Statement)((Object)invocation), binding);
        }
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer("Inference Context");
        switch (this.stepCompleted) {
            case 0: {
                buf.append(" (initial)");
                break;
            }
            case 1: {
                buf.append(" (applicability inferred)");
                break;
            }
            case 2: {
                buf.append(" (type inferred)");
                break;
            }
            case 3: {
                buf.append(" (bindings updated)");
            }
        }
        switch (this.inferenceKind) {
            case 1: {
                buf.append(" (strict)");
                break;
            }
            case 2: {
                buf.append(" (loose)");
                break;
            }
            case 3: {
                buf.append(" (vararg)");
            }
        }
        if (this.currentBounds != null && this.isResolved(this.currentBounds)) {
            buf.append(" (resolved)");
        }
        buf.append('\n');
        if (this.inferenceVariables != null) {
            buf.append("Inference Variables:\n");
            i = 0;
            while (i < this.inferenceVariables.length) {
                buf.append('\t').append(this.inferenceVariables[i].sourceName).append("\t:\t");
                if (this.currentBounds != null && this.currentBounds.isInstantiated(this.inferenceVariables[i])) {
                    buf.append(this.currentBounds.getInstantiation(this.inferenceVariables[i], this.environment).readableName());
                } else {
                    buf.append("NOT INSTANTIATED");
                }
                buf.append('\n');
                ++i;
            }
        }
        if (this.initialConstraints != null) {
            buf.append("Initial Constraints:\n");
            i = 0;
            while (i < this.initialConstraints.length) {
                if (this.initialConstraints[i] != null) {
                    buf.append('\t').append(this.initialConstraints[i].toString()).append('\n');
                }
                ++i;
            }
        }
        if (this.currentBounds != null) {
            buf.append(this.currentBounds.toString());
        }
        return buf.toString();
    }

    public void addProblemMethod(ProblemMethodBinding problemMethod) {
        if (this.problemMethods == null) {
            this.problemMethods = new ArrayList();
        }
        this.problemMethods.add(problemMethod);
    }

    public static ParameterizedTypeBinding parameterizedWithWildcard(TypeBinding type) {
        if (type == null || type.kind() != 260) {
            return null;
        }
        ParameterizedTypeBinding parameterizedType = (ParameterizedTypeBinding)type;
        TypeBinding[] arguments = parameterizedType.arguments;
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                if (arguments[i].isWildcard()) {
                    return parameterizedType;
                }
                ++i;
            }
        }
        return null;
    }

    public TypeBinding[] getFunctionInterfaceArgumentSolutions(TypeBinding[] a) {
        int m = a.length;
        TypeBinding[] aprime = new TypeBinding[m];
        int i = 0;
        while (i < this.inferenceVariables.length) {
            InferenceVariable alphai = this.inferenceVariables[i];
            TypeBinding t = this.currentBounds.getInstantiation(alphai, this.environment);
            aprime[i] = t != null ? t : a[i];
            ++i;
        }
        return aprime;
    }

    public void recordUncheckedConversion(ConstraintTypeFormula constraint) {
        if (this.constraintsWithUncheckedConversion == null) {
            this.constraintsWithUncheckedConversion = new ArrayList<ConstraintFormula>();
        }
        this.constraintsWithUncheckedConversion.add(constraint);
    }

    void reportUncheckedConversions(BoundSet solution) {
        if (this.constraintsWithUncheckedConversion != null) {
            int len = this.constraintsWithUncheckedConversion.size();
            Substitution substitution = this.getResultSubstitution(solution);
            int i = 0;
            while (i < len) {
                ConstraintTypeFormula constraint = (ConstraintTypeFormula)this.constraintsWithUncheckedConversion.get(i);
                TypeBinding expectedType = constraint.right;
                TypeBinding providedType = constraint.left;
                if (!expectedType.isProperType(true)) {
                    expectedType = Scope.substitute(substitution, expectedType);
                }
                if (!providedType.isProperType(true)) {
                    providedType = Scope.substitute(substitution, providedType);
                }
                ++i;
            }
        }
    }

    public boolean usesUncheckedConversion() {
        return this.constraintsWithUncheckedConversion != null;
    }

    public static void missingImplementation(String msg) {
        throw new UnsupportedOperationException(msg);
    }

    static class Solution {
        TypeBinding resolvedType;
        MethodBinding method;
        BoundSet bounds;

        Solution(MethodBinding method, BoundSet bounds) {
            this.method = method;
            this.resolvedType = method.isConstructor() ? method.declaringClass : method.returnType;
            this.bounds = bounds;
        }
    }

    static class SuspendedInferenceRecord {
        InvocationSite site;
        Expression[] invocationArguments;
        InferenceVariable[] inferenceVariables;
        int inferenceKind;

        SuspendedInferenceRecord(InvocationSite site, Expression[] invocationArguments, InferenceVariable[] inferenceVariables, int inferenceKind) {
            this.site = site;
            this.invocationArguments = invocationArguments;
            this.inferenceVariables = inferenceVariables;
            this.inferenceKind = inferenceKind;
        }
    }
}

